package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleValueRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg2ValueRule.NotionalQuantityScheduleLeg2ValueRuleDefault.class)
public abstract class NotionalQuantityScheduleLeg2ValueRule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleValueRule cDENotionalQuantityScheduleValueRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class NotionalQuantityScheduleLeg2ValueRuleDefault extends NotionalQuantityScheduleLeg2ValueRule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleValueRule.evaluate(input);
			
			return output;
		}
	}
}
