package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleAmountFormatDecimalRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(StrikePriceInEffectOnAssociatedEffectiveDateDecimalRule.StrikePriceInEffectOnAssociatedEffectiveDateDecimalRuleDefault.class)
public abstract class StrikePriceInEffectOnAssociatedEffectiveDateDecimalRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleAmountFormatDecimalRule cDEStrikePriceScheduleAmountFormatDecimalRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class StrikePriceInEffectOnAssociatedEffectiveDateDecimalRuleDefault extends StrikePriceInEffectOnAssociatedEffectiveDateDecimalRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleAmountFormatDecimalRule.evaluate(input);
			
			return output;
		}
	}
}
