package drr.regulation.jfsa.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg2Report;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class NotionalAmountScheduleLeg2ReportTypeFormatValidator implements Validator<NotionalAmountScheduleLeg2Report> {

	private List<ComparisonResult> getComparisonResults(NotionalAmountScheduleLeg2Report o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("amount", o.getAmount(), of(25), of(5), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, NotionalAmountScheduleLeg2Report o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("NotionalAmountScheduleLeg2Report", ValidationResult.ValidationType.TYPE_FORMAT, "NotionalAmountScheduleLeg2Report", path, "", res.getError());
				}
				return success("NotionalAmountScheduleLeg2Report", ValidationResult.ValidationType.TYPE_FORMAT, "NotionalAmountScheduleLeg2Report", path, "");
			})
			.collect(toList());
	}

}
