package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.NotionalAmountScheduleLeg2Report;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("JFSATransactionReportDTCC_JFSA_BR_0094_02")
@ImplementedBy(JFSATransactionReportDTCC_JFSA_BR_0094_02.Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0094_02 extends Validator<JFSATransactionReport> {
	
	String NAME = "JFSATransactionReportDTCC_JFSA_BR_0094_02";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType then (if notionalAmountScheduleLeg2 -> amount count <> notionalAmountScheduleLeg2 -> effectiveDate count then False else if notionalAmountScheduleLeg2 -> amount any < 0 then False)";
	
	class Default implements JFSATransactionReportDTCC_JFSA_BR_0094_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			ComparisonResult result = executeDataRule(jFSATransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSATransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(jFSATransactionReport).<String>map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (notEqual(MapperS.of(MapperS.of(jFSATransactionReport).<NotionalAmountScheduleLeg2Report>mapC("getNotionalAmountScheduleLeg2", _jFSATransactionReport -> _jFSATransactionReport.getNotionalAmountScheduleLeg2()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()).resultCount()), MapperS.of(MapperS.of(jFSATransactionReport).<NotionalAmountScheduleLeg2Report>mapC("getNotionalAmountScheduleLeg2", _jFSATransactionReport -> _jFSATransactionReport.getNotionalAmountScheduleLeg2()).<Date>map("getEffectiveDate", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getEffectiveDate()).resultCount()), CardinalityOperator.Any).getOrDefault(false)) {
						return ComparisonResult.ofNullSafe(MapperS.of(false));
					}
					if (lessThan(MapperS.of(jFSATransactionReport).<NotionalAmountScheduleLeg2Report>mapC("getNotionalAmountScheduleLeg2", _jFSATransactionReport -> _jFSATransactionReport.getNotionalAmountScheduleLeg2()).<BigDecimal>map("getAmount", notionalAmountScheduleLeg2Report -> notionalAmountScheduleLeg2Report.getAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.Any).getOrDefault(false)) {
						return ComparisonResult.ofNullSafe(MapperS.of(false));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSATransactionReportDTCC_JFSA_BR_0094_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
			return Collections.emptyList();
		}
	}
}
