package drr.regulation.mas.rewrite.margin.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.mas.rewrite.margin.MASMarginReport;
import iso20022.auth108.mas.CollateralisationType3Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class MASMarginReportOnlyExistsValidator implements ValidatorWithArg<MASMarginReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends MASMarginReport> ValidationResult<MASMarginReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2IdentifierType", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierType()))
				.put("reportingSpecifiedPerson", ExistenceChecker.isSet((String) o.getReportingSpecifiedPerson()))
				.put("dataSubmitter", ExistenceChecker.isSet((String) o.getDataSubmitter()))
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("uniqueTransactionIdentifierProprietary", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifierProprietary()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("collateralTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getCollateralTimestamp()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("initialMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getInitialMarginCollateralPortfolioCode()))
				.put("variationMarginCollateralPortfolioCode", ExistenceChecker.isSet((String) o.getVariationMarginCollateralPortfolioCode()))
				.put("initialMarginPostedByCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByCounterparty1PreHaircut()))
				.put("initialMarginPostedByCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginPostedByCounterparty1PostHaircut()))
				.put("initialMarginPostedByCounterparty1Currency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getInitialMarginPostedByCounterparty1Currency()))
				.put("initialMarginCollectedByCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByCounterparty1PreHaircut()))
				.put("initialMarginCollectedByCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getInitialMarginCollectedByCounterparty1PostHaircut()))
				.put("initialMarginCollectedByCounterparty1Currency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getInitialMarginCollectedByCounterparty1Currency()))
				.put("variationMarginPostedByCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByCounterparty1PreHaircut()))
				.put("variationMarginPostedByCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginPostedByCounterparty1PostHaircut()))
				.put("variationMarginPostedByCounterparty1Currency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getVariationMarginPostedByCounterparty1Currency()))
				.put("variationMarginCollectedByCounterparty1PreHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByCounterparty1PreHaircut()))
				.put("variationMarginCollectedByCounterparty1PostHaircut", ExistenceChecker.isSet((BigDecimal) o.getVariationMarginCollectedByCounterparty1PostHaircut()))
				.put("variationMarginCollectedByCounterparty1Currency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getVariationMarginCollectedByCounterparty1Currency()))
				.put("excessCollateralPostedByCounterparty1", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralPostedByCounterparty1()))
				.put("currencyOfExcessCollateralPosted", ExistenceChecker.isSet((String) o.getCurrencyOfExcessCollateralPosted()))
				.put("excessCollateralCollectedByCounterparty1", ExistenceChecker.isSet((BigDecimal) o.getExcessCollateralCollectedByCounterparty1()))
				.put("currencyOfExcessCollateralCollected", ExistenceChecker.isSet((String) o.getCurrencyOfExcessCollateralCollected()))
				.put("collateralisationCategory", ExistenceChecker.isSet((CollateralisationType3Code) o.getCollateralisationCategory()))
				.put("actionType", ExistenceChecker.isSet((MarginActionEnum) o.getActionType()))
				.put("eventDate", ExistenceChecker.isSet((ZonedDateTime) o.getEventDate()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("executionAgentOfTheCounterparty1", ExistenceChecker.isSet((String) o.getExecutionAgentOfTheCounterparty1()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("MASMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASMarginReport", path, "");
		}
		return failure("MASMarginReport", ValidationResult.ValidationType.ONLY_EXISTS, "MASMarginReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
