package drr.regulation.mas.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.mas.rewrite.trade.meta.StrikePriceScheduleReportMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.55.0
 */
@RosettaDataType(value="StrikePriceScheduleReport", builder=StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl.class, version="5.55.0")
@RuneDataType(value="StrikePriceScheduleReport", model="drr", builder=StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl.class, version="5.55.0")
public interface StrikePriceScheduleReport extends RosettaModelObject {

	StrikePriceScheduleReportMeta metaData = new StrikePriceScheduleReportMeta();

	/*********************** Getter Methods  ***********************/
	Date getEffectiveDate();
	Date getEndDate();
	BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary();
	BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateDecimal();
	PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate();

	/*********************** Build Methods  ***********************/
	StrikePriceScheduleReport build();
	
	StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder();
	
	static StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder() {
		return new StrikePriceScheduleReport.StrikePriceScheduleReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends StrikePriceScheduleReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends StrikePriceScheduleReport> getType() {
		return StrikePriceScheduleReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
		processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateMonetary"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this);
		processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateDecimal"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateDecimal(), this);
		processor.processBasic(path.newSubPath("strikePriceNotationInEffectOnAssociatedEffectiveDate"), PriceNotationEnum.class, getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface StrikePriceScheduleReportBuilder extends StrikePriceScheduleReport, RosettaModelObjectBuilder {
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEffectiveDate(Date effectiveDate);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEndDate(Date endDate);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateDecimal(BigDecimal strikePriceInEffectOnAssociatedEffectiveDateDecimal);
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceNotationInEffectOnAssociatedEffectiveDate(PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
			processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateMonetary"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this);
			processor.processBasic(path.newSubPath("strikePriceInEffectOnAssociatedEffectiveDateDecimal"), BigDecimal.class, getStrikePriceInEffectOnAssociatedEffectiveDateDecimal(), this);
			processor.processBasic(path.newSubPath("strikePriceNotationInEffectOnAssociatedEffectiveDate"), PriceNotationEnum.class, getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this);
		}
		

		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder prune();
	}

	/*********************** Immutable Implementation of StrikePriceScheduleReport  ***********************/
	class StrikePriceScheduleReportImpl implements StrikePriceScheduleReport {
		private final Date effectiveDate;
		private final Date endDate;
		private final BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		private final BigDecimal strikePriceInEffectOnAssociatedEffectiveDateDecimal;
		private final PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate;
		
		protected StrikePriceScheduleReportImpl(StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder) {
			this.effectiveDate = builder.getEffectiveDate();
			this.endDate = builder.getEndDate();
			this.strikePriceInEffectOnAssociatedEffectiveDateMonetary = builder.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary();
			this.strikePriceInEffectOnAssociatedEffectiveDateDecimal = builder.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal();
			this.strikePriceNotationInEffectOnAssociatedEffectiveDate = builder.getStrikePriceNotationInEffectOnAssociatedEffectiveDate();
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary() {
			return strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateDecimal() {
			return strikePriceInEffectOnAssociatedEffectiveDateDecimal;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		public PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate() {
			return strikePriceNotationInEffectOnAssociatedEffectiveDate;
		}
		
		@Override
		public StrikePriceScheduleReport build() {
			return this;
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder() {
			StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(StrikePriceScheduleReport.StrikePriceScheduleReportBuilder builder) {
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getEndDate()).ifPresent(builder::setEndDate);
			ofNullable(getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).ifPresent(builder::setStrikePriceInEffectOnAssociatedEffectiveDateMonetary);
			ofNullable(getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).ifPresent(builder::setStrikePriceInEffectOnAssociatedEffectiveDateDecimal);
			ofNullable(getStrikePriceNotationInEffectOnAssociatedEffectiveDate()).ifPresent(builder::setStrikePriceNotationInEffectOnAssociatedEffectiveDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateMonetary, _that.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateDecimal, _that.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal())) return false;
			if (!Objects.equals(strikePriceNotationInEffectOnAssociatedEffectiveDate, _that.getStrikePriceNotationInEffectOnAssociatedEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateMonetary != null ? strikePriceInEffectOnAssociatedEffectiveDateMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateDecimal != null ? strikePriceInEffectOnAssociatedEffectiveDateDecimal.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotationInEffectOnAssociatedEffectiveDate != null ? strikePriceNotationInEffectOnAssociatedEffectiveDate.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceScheduleReport {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateMonetary=" + this.strikePriceInEffectOnAssociatedEffectiveDateMonetary + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateDecimal=" + this.strikePriceInEffectOnAssociatedEffectiveDateDecimal + ", " +
				"strikePriceNotationInEffectOnAssociatedEffectiveDate=" + this.strikePriceNotationInEffectOnAssociatedEffectiveDate +
			'}';
		}
	}

	/*********************** Builder Implementation of StrikePriceScheduleReport  ***********************/
	class StrikePriceScheduleReportBuilderImpl implements StrikePriceScheduleReport.StrikePriceScheduleReportBuilder {
	
		protected Date effectiveDate;
		protected Date endDate;
		protected BigDecimal strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		protected BigDecimal strikePriceInEffectOnAssociatedEffectiveDateDecimal;
		protected PriceNotationEnum strikePriceNotationInEffectOnAssociatedEffectiveDate;
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateMonetary() {
			return strikePriceInEffectOnAssociatedEffectiveDateMonetary;
		}
		
		@Override
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		public BigDecimal getStrikePriceInEffectOnAssociatedEffectiveDateDecimal() {
			return strikePriceInEffectOnAssociatedEffectiveDateDecimal;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		public PriceNotationEnum getStrikePriceNotationInEffectOnAssociatedEffectiveDate() {
			return strikePriceNotationInEffectOnAssociatedEffectiveDate;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setEndDate(Date _endDate) {
			this.endDate = _endDate == null ? null : _endDate;
			return this;
		}
		
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateMonetary")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(BigDecimal _strikePriceInEffectOnAssociatedEffectiveDateMonetary) {
			this.strikePriceInEffectOnAssociatedEffectiveDateMonetary = _strikePriceInEffectOnAssociatedEffectiveDateMonetary == null ? null : _strikePriceInEffectOnAssociatedEffectiveDateMonetary;
			return this;
		}
		
		@RosettaAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		@RuneAttribute("strikePriceInEffectOnAssociatedEffectiveDateDecimal")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceInEffectOnAssociatedEffectiveDateDecimal(BigDecimal _strikePriceInEffectOnAssociatedEffectiveDateDecimal) {
			this.strikePriceInEffectOnAssociatedEffectiveDateDecimal = _strikePriceInEffectOnAssociatedEffectiveDateDecimal == null ? null : _strikePriceInEffectOnAssociatedEffectiveDateDecimal;
			return this;
		}
		
		@RosettaAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@RuneAttribute("strikePriceNotationInEffectOnAssociatedEffectiveDate")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder setStrikePriceNotationInEffectOnAssociatedEffectiveDate(PriceNotationEnum _strikePriceNotationInEffectOnAssociatedEffectiveDate) {
			this.strikePriceNotationInEffectOnAssociatedEffectiveDate = _strikePriceNotationInEffectOnAssociatedEffectiveDate == null ? null : _strikePriceNotationInEffectOnAssociatedEffectiveDate;
			return this;
		}
		
		@Override
		public StrikePriceScheduleReport build() {
			return new StrikePriceScheduleReport.StrikePriceScheduleReportImpl(this);
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEffectiveDate()!=null) return true;
			if (getEndDate()!=null) return true;
			if (getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()!=null) return true;
			if (getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()!=null) return true;
			if (getStrikePriceNotationInEffectOnAssociatedEffectiveDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			StrikePriceScheduleReport.StrikePriceScheduleReportBuilder o = (StrikePriceScheduleReport.StrikePriceScheduleReportBuilder) other;
			
			
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getEndDate(), o.getEndDate(), this::setEndDate);
			merger.mergeBasic(getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), o.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary(), this::setStrikePriceInEffectOnAssociatedEffectiveDateMonetary);
			merger.mergeBasic(getStrikePriceInEffectOnAssociatedEffectiveDateDecimal(), o.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal(), this::setStrikePriceInEffectOnAssociatedEffectiveDateDecimal);
			merger.mergeBasic(getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), o.getStrikePriceNotationInEffectOnAssociatedEffectiveDate(), this::setStrikePriceNotationInEffectOnAssociatedEffectiveDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			StrikePriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateMonetary, _that.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary())) return false;
			if (!Objects.equals(strikePriceInEffectOnAssociatedEffectiveDateDecimal, _that.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal())) return false;
			if (!Objects.equals(strikePriceNotationInEffectOnAssociatedEffectiveDate, _that.getStrikePriceNotationInEffectOnAssociatedEffectiveDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateMonetary != null ? strikePriceInEffectOnAssociatedEffectiveDateMonetary.hashCode() : 0);
			_result = 31 * _result + (strikePriceInEffectOnAssociatedEffectiveDateDecimal != null ? strikePriceInEffectOnAssociatedEffectiveDateDecimal.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotationInEffectOnAssociatedEffectiveDate != null ? strikePriceNotationInEffectOnAssociatedEffectiveDate.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "StrikePriceScheduleReportBuilder {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateMonetary=" + this.strikePriceInEffectOnAssociatedEffectiveDateMonetary + ", " +
				"strikePriceInEffectOnAssociatedEffectiveDateDecimal=" + this.strikePriceInEffectOnAssociatedEffectiveDateDecimal + ", " +
				"strikePriceNotationInEffectOnAssociatedEffectiveDate=" + this.strikePriceNotationInEffectOnAssociatedEffectiveDate +
			'}';
		}
	}
}
