package drr.regulation.mas.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class MASTradeLabelProvider extends GraphBasedLabelProvider {
	public MASTradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("counterparty1"), "1 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "2 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "3 Counterparty 2 Identifier Type");
		startNode.addLabel(Arrays.asList("tradingCapacityOfSpecifiedPerson"), "4 Trading Capacity Of Specified Person");
		startNode.addLabel(Arrays.asList("direction"), "5 Direction");
		startNode.addLabel(Arrays.asList("directionOfLeg1"), "6 Direction of leg 1");
		startNode.addLabel(Arrays.asList("directionOfLeg2"), "7 Direction of leg 2");
		startNode.addLabel(Arrays.asList("reportingSpecifiedPerson"), "8 Reporting specified person");
		startNode.addLabel(Arrays.asList("dataSubmitter"), "9 Data submitter");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifier"), "10 Unique Transaction Identifier (UTI)");
		startNode.addLabel(Arrays.asList("uniqueTransactionIdentifierProprietary"), "10 Unique Transaction Identifier (Proprietary)");
		startNode.addLabel(Arrays.asList("uniqueProductIdentifier"), "11 Unique product identifier (UPI)");
		startNode.addLabel(Arrays.asList("priorUTI"), "12 Prior UTI");
		startNode.addLabel(Arrays.asList("priorUTIProprietary"), "12 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("contractType"), "13 Contract Type");
		startNode.addLabel(Arrays.asList("assetClass"), "14 Asset Class");
		startNode.addLabel(Arrays.asList("underlying"), "15 Underlying");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "15.2 Underlying Identification Type (DTCC)");
		startNode.addLabel(Arrays.asList("underlyingIdOther"), "15.3 Underlying ID (Other) (DTCC)");
		startNode.addLabel(Arrays.asList("underlyingIdOtherSource"), "15.4 Underlying ID (Other) Source (DTCC)");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "15.5 Name of the underlying index (DTCC)");
		startNode.addLabel(Arrays.asList("fixedRateOfLeg1"), "16 Fixed Rate of leg 1 or coupon");
		startNode.addLabel(Arrays.asList("identifierOfFloatingRateOfLeg1"), "17 Identifier of the floating rate of leg 1");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg1"), "18 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("fixedRateOfLeg2"), "22 Fixed Rate of leg 2");
		startNode.addLabel(Arrays.asList("identifierOfFloatingRateOfLeg2"), "23 Identifier of the floating rate of leg 2");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg2"), "24 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("optionType"), "28 Option type");
		startNode.addLabel(Arrays.asList("optionStyle"), "29 Option Style");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "30 First exercise date");
		startNode.addLabel(Arrays.asList("effectiveDate"), "31 Effective Date");
		startNode.addLabel(Arrays.asList("expirationDate"), "32 Expiration Date");
		startNode.addLabel(Arrays.asList("swapLinkID"), "33 Swap link ID");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "34 Package identifier");
		startNode.addLabel(Arrays.asList("deliveryType"), "35 Delivery Type");
		startNode.addLabel(Arrays.asList("settlementCurrency1"), "36 Settlement Currency 1");
		startNode.addLabel(Arrays.asList("settlementCurrency2"), "37 Settlement Currency 2");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "38 Final Contractual Settlement Date");
		startNode.addLabel(Arrays.asList("cleared"), "39 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "40 Central Counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "41 Clearing member");
		startNode.addLabel(Arrays.asList("clearingTimestamp"), "42 Clearing Timestamp");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "43 Platform Identifier");
		startNode.addLabel(Arrays.asList("bookingLocation"), "45 Booking location");
		startNode.addLabel(Arrays.asList("traderLocation"), "46 Trader location");
		startNode.addLabel(Arrays.asList("confirmed"), "47 Confirmed");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "48 Confirmation Timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "49 Execution Timestamp");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "50 Reporting Timestamp");
		startNode.addLabel(Arrays.asList("valuationAmount"), "53 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "54 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "55 Valuation method");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "56 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "57 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "58.1 Initial margin collateral portfolio code (DTCC)");
		startNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "58.2 Variation margin collateral portfolio code (DTCC)");
		startNode.addLabel(Arrays.asList("notionalAmountOfTheContractOrLeg1"), "76 Notional amount of the contract or leg 1");
		startNode.addLabel(Arrays.asList("notionalCurrencyOfTheContractOrLeg1"), "77 Notional currency of the contract or leg 1");
		startNode.addLabel(Arrays.asList("notionalAmountOfLeg2"), "78 Notional amount of leg 2");
		startNode.addLabel(Arrays.asList("notionalCurrencyOfLeg2"), "79 Notional currency of leg 2");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityOfTheContractOrLeg1"), "80 Total notional quantity of the contract or leg 1");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureForTheContractOrLeg1"), "81 Quantity unit of measure for the contract or leg 1");
		startNode.addLabel(Arrays.asList("notionalQuantityOfTheContractOrLeg1"), "82 Notional quantity of the contract or leg 1");
		startNode.addLabel(Arrays.asList("quantityFrequencyOfTheContractOrLeg1"), "83 Quantity frequency of the contract or leg 1");
		startNode.addLabel(Arrays.asList("quantityFrequencyMultiplierOfTheContractOrLeg1"), "84 Quantity frequency multiplier of the contract or leg 1");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg2"), "85 Total notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg2"), "86 Quantity Unit Of Measure Leg 2");
		startNode.addLabel(Arrays.asList("notionalQuantityOfLeg2"), "87 Notional quantity of leg 2");
		startNode.addLabel(Arrays.asList("quantityFrequencyOfLeg2"), "88 Quantity frequency of leg 2");
		startNode.addLabel(Arrays.asList("quantityFrequencyMultiplierOfLeg2"), "89 Quantity frequency multiplier of leg 2");
		startNode.addLabel(Arrays.asList("callAmount"), "90 Call amount");
		startNode.addLabel(Arrays.asList("callCurrency"), "91 Call currency");
		startNode.addLabel(Arrays.asList("putAmount"), "92 Put Amount");
		startNode.addLabel(Arrays.asList("putCurrency"), "93 Put currency");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "97 Price unit of measure");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "107 Option Premium Amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "108 Option Premium Currency");
		startNode.addLabel(Arrays.asList("exchangeRate"), "109 Exchange rate");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "110 Exchange Rate Basis");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionOfLeg1"), "111 Fixed rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionOfLeg2"), "112 Fixed rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg1"), "113 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg2"), "114 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodOfLeg1"), "115 Floating rate reset frequency period of leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierOfLeg1"), "116 Floating rate reset frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodOfLeg2"), "117 Floating rate reset frequency period of Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierOfLeg2"), "118 Floating rate reset frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodOfLeg1"), "119 Fixed rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1"), "120 Fixed rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodOfLeg2"), "121 Fixed rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2"), "122 Fixed rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodOfLeg1"), "123 Floating rate payment frequency period of leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), "124 Floating rate payment frequency period multiplier of leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodOfLeg2"), "125 Floating rate payment frequency period of leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), "126 Floating rate payment frequency period multiplier of leg 2");
		startNode.addLabel(Arrays.asList("actionType"), "133 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "134 Event Type");
		startNode.addLabel(Arrays.asList("eventDate"), "135 Event Date");
		startNode.addLabel(Arrays.asList("technicalRecordId"), "[Internal] Technical Record Id (ISO)");
		startNode.addLabel(Arrays.asList("counterparty2Name"), "[Not in regulation] Counterparty 2 name (DTCC)");
		startNode.addLabel(Arrays.asList("executionAgentOfCounterparty1"), "[Not in regulation] Execution agent of Counterparty 1 (DTCC)");
		startNode.addLabel(Arrays.asList("executionAgentOfCounterparty2DTCC"), "[Not in regulation] Execution agent of Counterparty 2 (DTCC)");
		
		LabelNode spreadOfLeg1Node = new LabelNode();
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Monetary"), "19 Spread of Leg 1 (Monetary)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Decimal"), "19 Spread of Leg 1 (Decimal)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Basis"), "19 Spread of Leg 1 (Basis)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadNotationOfLeg1"), "19 Spread Notation of Leg 1");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadCurrencyOfLeg1"), "2.94 Spread Currency of Leg 1");
		
		LabelNode spreadOfLeg2Node = new LabelNode();
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Monetary"), "25 Spread of Leg 2 (Monetary)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Decimal"), "25 Spread of Leg 2 (Decimal)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Basis"), "25 Spread of Leg 2 (Basis)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadNotationOfLeg2"), "26 Spread notation of leg 2");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadCurrencyOfLeg2"), "27 Spread Currency of Leg 2");
		
		LabelNode priceAndNotationNode = new LabelNode();
		priceAndNotationNode.addLabel(Arrays.asList("priceMonetary"), "2.48 Price (Monetary)");
		priceAndNotationNode.addLabel(Arrays.asList("priceDecimal"), "2.48 Price (Decimal)");
		priceAndNotationNode.addLabel(Arrays.asList("priceCurrency"), "95 Price currency");
		priceAndNotationNode.addLabel(Arrays.asList("priceNotation"), "96 Price notation");
		
		LabelNode strikePriceAndNotationNode = new LabelNode();
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceMonetary"), "101 Strike Price (Monetary)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceDecimal"), "101 Strike Price (Decimal)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceCurrency"), "102 Strike price currency/currency pair");
		
		LabelNode mASNonReportableNode = new LabelNode();
		mASNonReportableNode.addLabel(Arrays.asList("enrichment"), "Enrichment Data");
		mASNonReportableNode.addLabel(Arrays.asList("preUpiData"), "Upi Pre-Enrichment Data");
		mASNonReportableNode.addLabel(Arrays.asList("postUpiData"), "Upi Post-Enrichment Data");
		
		startNode.addOutgoingEdge("spreadOfLeg1", spreadOfLeg1Node);
		startNode.addOutgoingEdge("spreadOfLeg2", spreadOfLeg2Node);
		startNode.addOutgoingEdge("price", priceAndNotationNode);
		startNode.addOutgoingEdge("strikePrice", strikePriceAndNotationNode);
		startNode.addOutgoingEdge("nonReportable", mASNonReportableNode);
	}
}
