package drr.regulation.mas.rewrite.trade.reports;

import cdm.event.common.TradeState;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsOtherPayment;
import drr.regulation.common.functions.TradeStateForEvent;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import drr.regulation.mas.rewrite.trade.functions.ExtractOtherPaymentPayerMas;
import drr.regulation.mas.rewrite.trade.functions.ExtractOtherPaymentReceiverMas;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentRule.OtherPaymentRuleDefault.class)
public abstract class OtherPaymentRule implements ReportFunction<TransactionReportInstruction, List<? extends OtherPaymentReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractOtherPaymentPayerMas extractOtherPaymentPayerMas;
	@Inject protected ExtractOtherPaymentReceiverMas extractOtherPaymentReceiverMas;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsOtherPayment isOtherPayment;
	@Inject protected OtherPaymentAmountRule otherPaymentAmountRule;
	@Inject protected OtherPaymentCurrencyRule otherPaymentCurrencyRule;
	@Inject protected OtherPaymentDateRule otherPaymentDateRule;
	@Inject protected OtherPaymentPayerFormatRule otherPaymentPayerFormatRule;
	@Inject protected OtherPaymentReceiverFormatRule otherPaymentReceiverFormatRule;
	@Inject protected OtherPaymentTypeRule otherPaymentTypeRule;
	@Inject protected TradeStateForEvent tradeStateForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends OtherPaymentReport> evaluate(TransactionReportInstruction input) {
		List<OtherPaymentReport.OtherPaymentReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends OtherPaymentReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(OtherPaymentReport::build).collect(Collectors.toList());
			objectValidator.validate(OtherPaymentReport.class, output);
		}
		
		return output;
	}

	protected abstract List<OtherPaymentReport.OtherPaymentReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class OtherPaymentRuleDefault extends OtherPaymentRule {
		@Override
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<OtherPaymentReport.OtherPaymentReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> assignOutput(List<OtherPaymentReport.OtherPaymentReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe(MapperS.of(isAllowableActionForMAS.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isActionTypeTERM.evaluate(item.get())))).get());
			output = toBuilder(thenArg
				.mapSingleToList(transactionReportInstruction -> {
					final MapperS<TradeState> thenArg0 = MapperS.of(tradeStateForEvent.evaluate(thenArg.get()));
					final MapperC<TransferState> thenArg1 = thenArg0
						.mapSingleToList(item -> item.<TransferState>mapC("getTransferHistory", tradeState -> tradeState.getTransferHistory()));
					final MapperC<TransferState> thenArg2 = thenArg1
						.filterItemNullSafe(item -> isOtherPayment.evaluate(item.get()));
					return thenArg2
						.mapItem(item -> MapperS.of(OtherPaymentReport.builder()
							.setPaymentType(otherPaymentTypeRule.evaluate(item.get()))
							.setAmount(otherPaymentAmountRule.evaluate(item.get()))
							.setCurrency(otherPaymentCurrencyRule.evaluate(item.get()))
							.setDate(otherPaymentDateRule.evaluate(item.get()))
							.setPayer(extractOtherPaymentPayerMas.evaluate(item.get(), transactionReportInstruction.get()))
							.setPayerFormat(otherPaymentPayerFormatRule.evaluate(item.get()))
							.setReceiver(extractOtherPaymentReceiverMas.evaluate(item.get(), transactionReportInstruction.get()))
							.setReceiverFormat(otherPaymentReceiverFormatRule.evaluate(item.get()))
							.build()));
				}).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
