package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0019_02")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0019_02.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0019_02 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0019_02";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and (assetClass = \"INTR\" and [\"CFDS\", \"FORW\", \"OPTN\", \"OTHR\"] any = contractType) then if price is absent and spreadOfLeg2 is absent then (spreadOfLeg1 -> spreadOfLeg1Monetary exists or spreadOfLeg1 -> spreadOfLeg1Decimal exists or spreadOfLeg1 -> spreadOfLeg1Basis exists)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0019_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All).andNullSafe(areEqual(MapperC.<String>of(MapperS.of("CFDS"), MapperS.of("FORW"), MapperS.of("OPTN"), MapperS.of("OTHR")), MapperS.of(mASTransactionReport).<String>map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), CardinalityOperator.Any))).getOrDefault(false)) {
					if (notExists(MapperS.of(mASTransactionReport).<PriceAndNotation>map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice())).andNullSafe(notExists(MapperS.of(mASTransactionReport).<SpreadOfLeg2>map("getSpreadOfLeg2", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg2()))).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Monetary", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Monetary())).orNullSafe(exists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Decimal", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Decimal()))).orNullSafe(exists(MapperS.of(mASTransactionReport).<SpreadOfLeg1>map("getSpreadOfLeg1", _mASTransactionReport -> _mASTransactionReport.getSpreadOfLeg1()).<BigDecimal>map("getSpreadOfLeg1Basis", spreadOfLeg1 -> spreadOfLeg1.getSpreadOfLeg1Basis())));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0019_02 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
