package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0094_02b")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0094_02b.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0094_02b extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0094_02b";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and (assetClass = \"INTR\" and contractType = \"SWAP\") then (if priceSchedule -> priceMonetary exists or priceSchedule -> priceDecimal exists then price exists)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0094_02b {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<String>map("getContractType", _mASTransactionReport -> _mASTransactionReport.getContractType()), MapperS.of("SWAP"), CardinalityOperator.All))).getOrDefault(false)) {
					if (exists(MapperS.of(mASTransactionReport).<PriceScheduleReport>mapC("getPriceSchedule", _mASTransactionReport -> _mASTransactionReport.getPriceSchedule()).<BigDecimal>map("getPriceMonetary", priceScheduleReport -> priceScheduleReport.getPriceMonetary())).orNullSafe(exists(MapperS.of(mASTransactionReport).<PriceScheduleReport>mapC("getPriceSchedule", _mASTransactionReport -> _mASTransactionReport.getPriceSchedule()).<BigDecimal>map("getPriceDecimal", priceScheduleReport -> priceScheduleReport.getPriceDecimal()))).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<PriceAndNotation>map("getPrice", _mASTransactionReport -> _mASTransactionReport.getPrice()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0094_02b {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
