package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.55.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0133_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0133_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0133_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0133_01";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> INCP to-string, EventTypeEnum -> CORP to-string ] any = eventType else if actionType = ActionTypeEnum -> MODI to-string then [ EventTypeEnum -> TRAD to-string, EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> INCP to-string, EventTypeEnum -> UPDT to-string ] any = eventType else if actionType = ActionTypeEnum -> TERM to-string then [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> COMP to-string, EventTypeEnum -> ETRM to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLAL to-string, EventTypeEnum -> CREV to-string, EventTypeEnum -> CORP to-string, EventTypeEnum -> INCP to-string ] any = eventType else if actionType = ActionTypeEnum -> PRTO to-string then eventType = EventTypeEnum -> PTNG to-string else if [ ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string, ActionTypeEnum -> EROR to-string, ActionTypeEnum -> VALU to-string ] any = actionType then True";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0133_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getEventType", _mASTransactionReport -> _mASTransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.TRAD).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.UPDT).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getEventType", _mASTransactionReport -> _mASTransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperC.<String>of(MapperS.of(EventTypeEnum.NOVA).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.COMP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ETRM).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLRG).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.EXER).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.ALOC).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CLAL).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CREV).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.CORP).map("to-string", EventTypeEnum::toDisplayString), MapperS.of(EventTypeEnum.INCP).map("to-string", EventTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getEventType", _mASTransactionReport -> _mASTransactionReport.getEventType()), CardinalityOperator.Any);
				}
				if (areEqual(MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperS.of(mASTransactionReport).<String>map("getEventType", _mASTransactionReport -> _mASTransactionReport.getEventType()), MapperS.of(EventTypeEnum.PTNG).map("to-string", EventTypeEnum::toDisplayString), CardinalityOperator.All);
				}
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					return ComparisonResult.ofNullSafe(MapperS.of(true));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0133_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
