package drr.regulation.mas.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.mas.rewrite.trade.StrikePriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class StrikePriceScheduleReportOnlyExistsValidator implements ValidatorWithArg<StrikePriceScheduleReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends StrikePriceScheduleReport> ValidationResult<StrikePriceScheduleReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("endDate", ExistenceChecker.isSet((Date) o.getEndDate()))
				.put("strikePriceInEffectOnAssociatedEffectiveDateMonetary", ExistenceChecker.isSet((BigDecimal) o.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()))
				.put("strikePriceInEffectOnAssociatedEffectiveDateDecimal", ExistenceChecker.isSet((BigDecimal) o.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()))
				.put("strikePriceNotationInEffectOnAssociatedEffectiveDate", ExistenceChecker.isSet((PriceNotationEnum) o.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("StrikePriceScheduleReport", ValidationResult.ValidationType.ONLY_EXISTS, "StrikePriceScheduleReport", path, "");
		}
		return failure("StrikePriceScheduleReport", ValidationResult.ValidationType.ONLY_EXISTS, "StrikePriceScheduleReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
