package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(BookingLocationRule.BookingLocationRuleDefault.class)
public abstract class BookingLocationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BookingLocationAddressRule bookingLocationAddressRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class BookingLocationRuleDefault extends BookingLocationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Address> thenArg = MapperS.of(bookingLocationAddressRule.evaluate(input));
			final FieldWithMetaString fieldWithMetaString = thenArg
				.mapSingleToItem(item -> item.<FieldWithMetaString>map("getCountry", address -> address.getCountry())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
