package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(InterestRateDayCountLeg1Rule.InterestRateDayCountLeg1RuleDefault.class)
public abstract class InterestRateDayCountLeg1Rule implements ReportFunction<TransactionReportInstruction, DayCountFractionEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg1Rule fixedFloatLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public DayCountFractionEnum evaluate(TransactionReportInstruction input) {
		DayCountFractionEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract DayCountFractionEnum doEvaluate(TransactionReportInstruction input);

	public static class InterestRateDayCountLeg1RuleDefault extends InterestRateDayCountLeg1Rule {
		@Override
		protected DayCountFractionEnum doEvaluate(TransactionReportInstruction input) {
			DayCountFractionEnum output = null;
			return assignOutput(output, input);
		}
		
		protected DayCountFractionEnum assignOutput(DayCountFractionEnum output, TransactionReportInstruction input) {
			final MapperS<InterestRatePayout> thenArg0 = MapperS.of(fixedFloatLeg1Rule.evaluate(input));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			final FieldWithMetaDayCountFractionEnum fieldWithMetaDayCountFractionEnum = thenArg1
				.mapSingleToItem(item -> item.<FieldWithMetaDayCountFractionEnum>map("getDayCountFraction", interestRatePayout -> interestRatePayout.getDayCountFraction())).get();
			if (fieldWithMetaDayCountFractionEnum == null) {
				output = null;
			} else {
				output = fieldWithMetaDayCountFractionEnum.getValue();
			}
			
			return output;
		}
	}
}
