package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsAddressInSingaporeRule.IsAddressInSingaporeRuleDefault.class)
public abstract class IsAddressInSingaporeRule implements ReportFunction<Address, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(Address input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(Address input);

	public static class IsAddressInSingaporeRuleDefault extends IsAddressInSingaporeRule {
		@Override
		protected Boolean doEvaluate(Address input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, Address input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> areEqual(item.<FieldWithMetaString>map("getCountry", address -> address.getCountry()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), MapperS.of("SG"), CardinalityOperator.All).asMapper()).get();
			
			return output;
		}
	}
}
