package drr.standards.iosco.cde.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEExchangeRateBasisRule.CDEExchangeRateBasisRuleDefault.class)
public abstract class CDEExchangeRateBasisRule implements ReportFunction<PriceSchedule, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(PriceSchedule input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(PriceSchedule input);

	public static class CDEExchangeRateBasisRuleDefault extends CDEExchangeRateBasisRule {
		@Override
		protected String doEvaluate(PriceSchedule input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, PriceSchedule input) {
			final FieldWithMetaString fieldWithMetaString0 = MapperS.of(input).<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			final FieldWithMetaString fieldWithMetaString1 = MapperS.of(input).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			if (exists(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())))).andNullSafe(exists(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()))))).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString2 = MapperS.of(input).<UnitType>map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				final FieldWithMetaString fieldWithMetaString3 = MapperS.of(input).<UnitType>map("getUnit", priceSchedule -> priceSchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
				output = MapperMaths.<String, String, String>add(MapperMaths.<String, String, String>add(MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString), MapperS.of("/")), MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue()))).map("to-string", ISOCurrencyCodeEnum::toDisplayString)).get();
			} else {
				output = null;
			}
			
			return output;
		}
	}
}
