package drr.standards.iosco.cde.reports;

import cdm.base.math.UnitType;
import cdm.observable.asset.Price;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStrike;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;


@ImplementedBy(CDEOptionNotionalCurrencyRule.CDEOptionNotionalCurrencyRuleDefault.class)
public abstract class CDEOptionNotionalCurrencyRule implements ReportFunction<OptionPayout, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(OptionPayout input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(OptionPayout input);

	public static class CDEOptionNotionalCurrencyRuleDefault extends CDEOptionNotionalCurrencyRule {
		@Override
		protected String doEvaluate(OptionPayout input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, OptionPayout input) {
			final FieldWithMetaString fieldWithMetaString = MapperS.of(input).<OptionExercise>map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).<OptionStrike>map("getStrike", optionExercise -> optionExercise.getStrike()).<Price>map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).<UnitType>map("getUnit", price -> price.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
