package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.functions.FormatToBaseOne18Rate;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEPriceScheduleAmountFormatMonetaryRule.CDEPriceScheduleAmountFormatMonetaryRuleDefault.class)
public abstract class CDEPriceScheduleAmountFormatMonetaryRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToBaseOne18Rate formatToBaseOne18Rate;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class CDEPriceScheduleAmountFormatMonetaryRuleDefault extends CDEPriceScheduleAmountFormatMonetaryRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			final MapperS<PriceAndNotation> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<PriceAndNotation>map("getPeriodValue", priceReportablePeriod -> priceReportablePeriod.getPeriodValue()));
			final MapperS<BigDecimal> ifThenElseResult;
			if (areEqual(thenArg.<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(multiplyPrice.evaluate(thenArg.<BigDecimal>map("getPriceMonetary", priceAndNotation -> priceAndNotation.getPriceMonetary()).get(), thenArg.<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()).get()));
			} else {
				ifThenElseResult = MapperS.<BigDecimal>ofNull();
			}
			output = MapperS.of(formatToBaseOne18Rate.evaluate(ifThenElseResult.get())).get();
			
			return output;
		}
	}
}
