package drr.standards.iosco.cde.reports;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.Measure;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.UnitType;
import cdm.base.math.WeatherUnitEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.regulation.common.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEQuantityUnitOfMeasureRule.CDEQuantityUnitOfMeasureRuleDefault.class)
public abstract class CDEQuantityUnitOfMeasureRule implements ReportFunction<NonNegativeQuantitySchedule, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
	@Inject protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
	@Inject protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(NonNegativeQuantitySchedule input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(NonNegativeQuantitySchedule input);

	public static class CDEQuantityUnitOfMeasureRuleDefault extends CDEQuantityUnitOfMeasureRule {
		@Override
		protected String doEvaluate(NonNegativeQuantitySchedule input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, NonNegativeQuantitySchedule input) {
			final MapperS<UnitType> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (exists(item.<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(false)) {
						return item.<Measure>map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).<UnitType>map("getUnit", measure -> measure.getUnit());
					}
					return item.<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
				});
			output = thenArg
				.mapSingleToItem(item -> {
					if (exists(item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(false)) {
						return MapperS.of(capacityUnitToISO20022UnitOfMeasure.evaluate(item.<CapacityUnitEnum>map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
					}
					if (exists(item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(false)) {
						return MapperS.of(weatherUnitToISO20022UnitOfMeasure.evaluate(item.<WeatherUnitEnum>map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
					}
					if (exists(item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(false)) {
						return MapperS.of(financialUnitToISO20022UnitOfMeasure.evaluate(item.<FinancialUnitEnum>map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
