package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetValuation;
import java.time.ZonedDateTime;
import javax.inject.Inject;


@ImplementedBy(CDEValuationTimestampRule.CDEValuationTimestampRuleDefault.class)
public abstract class CDEValuationTimestampRule implements ReportFunction<TransactionReportInstruction, ZonedDateTime> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetValuation getValuation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ZonedDateTime evaluate(TransactionReportInstruction input) {
		ZonedDateTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract ZonedDateTime doEvaluate(TransactionReportInstruction input);

	public static class CDEValuationTimestampRuleDefault extends CDEValuationTimestampRule {
		@Override
		protected ZonedDateTime doEvaluate(TransactionReportInstruction input) {
			ZonedDateTime output = null;
			return assignOutput(output, input);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(getValuation.evaluate(item.get())).<ZonedDateTime>map("getTimestamp", valuation -> valuation.getTimestamp())).get();
			
			return output;
		}
	}
}
