# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ObservationSource']


class ObservationSource(BaseDataClass):
    """
    The observation source can be composed of an curve and/or and information source.
    """
    curve: Optional[cdm.observable.asset.Curve.Curve] = Field(None, description="")
    informationSource: Optional[cdm.observable.asset.InformationSource.InformationSource] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_CurveInformationSource(self):
        """
        ObservationSource should not be empty, although the attribute cardinality would allow that.
        """
        item = self
        return (((rosetta_attr_exists(rosetta_resolve_attr(self, "curve")) and rosetta_attr_exists(rosetta_resolve_attr(self, "informationSource"))) or rosetta_attr_exists(rosetta_resolve_attr(self, "curve"))) or rosetta_attr_exists(rosetta_resolve_attr(self, "informationSource")))

import cdm 
import cdm.observable.asset.Curve
import cdm.observable.asset.InformationSource
