# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionalEarlyTermination']


class OptionalEarlyTermination(BaseDataClass):
    """
    A data defining:  an early termination provision where either or both parties have the right to exercise.
    """
    singlePartyOption: Optional[cdm.base.staticdata.party.BuyerSeller.BuyerSeller] = Field(None, description="If optional early termination is not available to both parties then this component specifies the buyer and seller of the option. In FpML, this attribute is of type SinglePsrtyOption, which actually consists of the BuyerSeller.model.")
    """
    If optional early termination is not available to both parties then this component specifies the buyer and seller of the option. In FpML, this attribute is of type SinglePsrtyOption, which actually consists of the BuyerSeller.model.
    """
    mutualEarlyTermination: Optional[bool] = Field(None, description="Used for specifying whether the Mutual Early Termination Right that is detailed in the Master Confirmation will apply.")
    """
    Used for specifying whether the Mutual Early Termination Right that is detailed in the Master Confirmation will apply.
    """
    americanExercise: Optional[cdm.product.template.AmericanExercise.AmericanExercise] = Field(None, description="American exercise. FpML implementations consists in an exercise substitution group.")
    """
    American exercise. FpML implementations consists in an exercise substitution group.
    """
    bermudaExercise: Optional[cdm.product.template.BermudaExercise.BermudaExercise] = Field(None, description="Bermuda exercise. FpML implementations consists in an exercise substitution group.")
    """
    Bermuda exercise. FpML implementations consists in an exercise substitution group.
    """
    europeanExercise: Optional[cdm.product.template.EuropeanExercise.EuropeanExercise] = Field(None, description="European exercise. FpML implementations consists in an exercise substitution group.")
    """
    European exercise. FpML implementations consists in an exercise substitution group.
    """
    exerciseNotice: List[cdm.product.template.ExerciseNotice.ExerciseNotice] = Field([], description="Definition of the party to whom notice of exercise should be given.")
    """
    Definition of the party to whom notice of exercise should be given.
    """
    followUpConfirmation: Optional[bool] = Field(None, description="A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.")
    """
    A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.
    """
    calculationAgent: Optional[cdm.observable.asset.CalculationAgent.CalculationAgent] = Field(None, description="The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.")
    """
    The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
    """
    cashSettlement: Optional[cdm.product.common.settlement.SettlementTerms.SettlementTerms] = Field(None, description="If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.")
    """
    If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
    """
    optionalEarlyTerminationAdjustedDates: Optional[cdm.product.template.OptionalEarlyTerminationAdjustedDates.OptionalEarlyTerminationAdjustedDates] = Field(None, description="An early termination provision to terminate the trade at fair value where one or both parties have the right to decide on termination.")
    """
    An early termination provision to terminate the trade at fair value where one or both parties have the right to decide on termination.
    """
    
    @rosetta_condition
    def condition_0_ExerciseChoice(self):
        """
        condition to represent an FpML choice construct.
        """
        item = self
        return rosetta_check_one_of(self, 'americanExercise', 'bermudaExercise', 'europeanExercise', necessity=False)
    
    @rosetta_condition
    def condition_1_OptionalEarlyTerminationExerciseNoticeReceiverParty(self):
        item = self
        def _then_fn0():
            return contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_OPTIONAL_EARLY_TERMINATION"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_MandatoryEarlyTerminationCalculationAgent(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_OPTIONAL_EARLY_TERMINATION"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.BuyerSeller
import cdm.product.template.AmericanExercise
import cdm.product.template.BermudaExercise
import cdm.product.template.EuropeanExercise
import cdm.product.template.ExerciseNotice
import cdm.observable.asset.CalculationAgent
import cdm.product.common.settlement.SettlementTerms
import cdm.product.template.OptionalEarlyTerminationAdjustedDates
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
