# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['TerminationProvision']


class TerminationProvision(BaseDataClass):
    """
    A class for defining option provisions.
    """
    cancelableProvision: Optional[cdm.product.template.CancelableProvision.CancelableProvision] = Field(None, description="A provision that allows the specification of an embedded option within a swap giving the buyer of the option the right to terminate the swap, in whole or in part, on the early termination date.")
    """
    A provision that allows the specification of an embedded option within a swap giving the buyer of the option the right to terminate the swap, in whole or in part, on the early termination date.
    """
    earlyTerminationProvision: Optional[cdm.product.template.EarlyTerminationProvision.EarlyTerminationProvision] = Field(None, description="Parameters specifying provisions relating to the optional and mandatory early termination of a swap transaction.")
    """
    Parameters specifying provisions relating to the optional and mandatory early termination of a swap transaction.
    """
    evergreenProvision: Optional[cdm.product.template.EvergreenProvision.EvergreenProvision] = Field(None, description="A data defining: the right of a party to exercise an Evergreen option")
    """
    A data defining: the right of a party to exercise an Evergreen option
    """
    extendibleProvision: Optional[cdm.product.template.ExtendibleProvision.ExtendibleProvision] = Field(None, description="A provision that allows the specification of an embedded option with a swap giving the buyer of the option the right to extend the swap, in whole or in part, to the extended termination date.")
    """
    A provision that allows the specification of an embedded option with a swap giving the buyer of the option the right to extend the swap, in whole or in part, to the extended termination date.
    """
    
    @rosetta_condition
    def condition_0_TerminationProvisionChoice(self):
        item = self
        return rosetta_check_one_of(self, 'cancelableProvision', 'extendibleProvision', 'evergreenProvision', 'earlyTerminationProvision', necessity=True)

import cdm 
import cdm.product.template.CancelableProvision
import cdm.product.template.EarlyTerminationProvision
import cdm.product.template.EvergreenProvision
import cdm.product.template.ExtendibleProvision
