/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.CreditDerivative4__1;
import iso20022.auth030.fca.DebtInstrumentSeniorityType2Code;
import iso20022.auth030.fca.DerivativePartyIdentification1Choice;
import iso20022.auth030.fca.NoReasonCode;
import iso20022.auth030.fca.Tranche3__1;
import iso20022.auth030.fca.TrancheIndicator3Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCdtDefault.class)
public abstract class GetCdt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CreditDerivative4__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        CreditDerivative4__1 cdt;
        CreditDerivative4__1.CreditDerivative4__1Builder cdtBuilder = this.doEvaluate(drrReport);
        if (cdtBuilder == null) {
            cdt = null;
        } else {
            cdt = cdtBuilder.build();
            this.objectValidator.validate(CreditDerivative4__1.class, (RosettaModelObject)cdt);
        }
        return cdt;
    }

    protected abstract CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetCdtDefault
    extends GetCdt {
        @Override
        protected CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            CreditDerivative4__1.CreditDerivative4__1Builder cdt = CreditDerivative4__1.builder();
            return this.assignOutput(cdt, drrReport);
        }

        protected CreditDerivative4__1.CreditDerivative4__1Builder assignOutput(CreditDerivative4__1.CreditDerivative4__1Builder cdt, FCAUKEMIRTransactionReport drrReport) {
            TrancheIndicator3Choice__1 ifThenElseResult2 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getTranche", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getTranche()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                Tranche3__1 ifThenElseResult0 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getTranche", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getTranche()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = Tranche3__1.builder().setAttchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexAttachmentPoint", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getCdSIndexAttachmentPoint()).get()).setDtchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexDetachmentPoint", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getCdSIndexDetachmentPoint()).get()).build();
                }
                NoReasonCode ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getTranche", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getTranche()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = NoReasonCode.NORE;
                }
                ifThenElseResult2 = TrancheIndicator3Choice__1.builder().setTrnchd(ifThenElseResult0).setUtrnchd(ifThenElseResult1).build();
            }
            cdt = (CreditDerivative4__1.CreditDerivative4__1Builder)this.toBuilder((RosettaModelObject)CreditDerivative4__1.builder().setSnrty((DebtInstrumentSeniorityType2Code)MapperS.of((Object)drrReport).map("getSeniority", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSeniority()).checkedMap("to-enum", DebtInstrumentSeniorityType2Code::fromDisplayName, IllegalArgumentException.class).get()).setRefPty(DerivativePartyIdentification1Choice.builder().setLei((String)MapperS.of((Object)drrReport).map("getReferenceEntity", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getReferenceEntity()).get()).build()).setSrs((Integer)MapperS.of((Object)drrReport).map("getSeries", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSeries()).get()).setVrsn((Integer)MapperS.of((Object)drrReport).map("getVersion", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getVersion()).get()).setIndxFctr((BigDecimal)MapperS.of((Object)drrReport).map("getIndexFactor", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getIndexFactor()).get()).setTrch(ifThenElseResult2).build());
            return Optional.ofNullable(cdt).map(o -> o.prune()).orElse(null);
        }
    }
}

