/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd20Amount;
import iso20022.auth030.fca.AmountAndDirection106__3;
import iso20022.auth030.fca.DatePeriod1;
import iso20022.auth030.fca.DeliveryInterconnectionPoint1Choice__1;
import iso20022.auth030.fca.DurationType1Code;
import iso20022.auth030.fca.EnergyDeliveryAttribute10__1;
import iso20022.auth030.fca.EnergyLoadType1Code;
import iso20022.auth030.fca.EnergyQuantityUnit2Choice__1;
import iso20022.auth030.fca.EnergyQuantityUnit2Code;
import iso20022.auth030.fca.EnergySpecificAttribute9__1;
import iso20022.auth030.fca.Quantity47Choice__1;
import iso20022.auth030.fca.TimePeriodDetails1;
import iso20022.auth030.fca.WeekDay3Code__1;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNrgySpcfcAttrbtsDefault.class)
public abstract class GetNrgySpcfcAttrbts
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public EnergySpecificAttribute9__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        EnergySpecificAttribute9__1 nrgySpcfcAttrbts;
        EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder nrgySpcfcAttrbtsBuilder = this.doEvaluate(drrReport);
        if (nrgySpcfcAttrbtsBuilder == null) {
            nrgySpcfcAttrbts = null;
        } else {
            nrgySpcfcAttrbts = nrgySpcfcAttrbtsBuilder.build();
            this.objectValidator.validate(EnergySpecificAttribute9__1.class, (RosettaModelObject)nrgySpcfcAttrbts);
        }
        return nrgySpcfcAttrbts;
    }

    protected abstract EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetNrgySpcfcAttrbtsDefault
    extends GetNrgySpcfcAttrbts {
        @Override
        protected EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder nrgySpcfcAttrbts = EnergySpecificAttribute9__1.builder();
            return this.assignOutput(nrgySpcfcAttrbts, drrReport);
        }

        protected EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder assignOutput(EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder nrgySpcfcAttrbts, FCAUKEMIRTransactionReport drrReport) {
            String ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)"COMM"), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getBaseProduct", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getBaseProduct()), (Mapper)MapperS.of((Object)"NRGY"), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getSubProduct", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSubProduct()), (Mapper)MapperS.of((Object)"ELEC"), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getSubProduct", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getSubProduct()), (Mapper)MapperS.of((Object)"NGAS"), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = (String)MapperS.of((Object)drrReport).map("getInterconnectionPoint", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getInterconnectionPoint()).map("to-string", Object::toString).get();
            }
            EnergyLoadType1Code ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)drrReport).mapC("getDeliveryPoint", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getDeliveryPoint())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = (EnergyLoadType1Code)MapperS.of((Object)drrReport).map("getLoadType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getLoadType()).get();
            }
            nrgySpcfcAttrbts = (EnergySpecificAttribute9__1.EnergySpecificAttribute9__1Builder)this.toBuilder((RosettaModelObject)EnergySpecificAttribute9__1.builder().setDlvryPtOrZone((DeliveryInterconnectionPoint1Choice__1)MapperS.of((Object)((String)MapperS.of((Object)drrReport).mapC("getDeliveryPoint", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getDeliveryPoint()).get())).mapSingleToItem(item -> MapperS.of((Object)DeliveryInterconnectionPoint1Choice__1.builder().setCd((String)item.get()).build())).get()).setIntrCnnctnPt(DeliveryInterconnectionPoint1Choice__1.builder().setCd(ifThenElseResult0).build()).setLdTp(ifThenElseResult1).setDlvryAttr(MapperS.of((Object)drrReport).mapC("getDeliveryReport", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getDeliveryReport()).mapItem(item -> {
                TimePeriodDetails1 timePeriodDetails1 = TimePeriodDetails1.builder().setFrTm((LocalTime)item.map("getDeliveryStartTime", deliveryReport -> deliveryReport.getDeliveryStartTime()).get()).setToTm((LocalTime)item.map("getDeliveryEndTime", deliveryReport -> deliveryReport.getDeliveryEndTime()).get()).build();
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getPriceTimeIntervalQuantity", deliveryReport -> deliveryReport.getPriceTimeIntervalQuantity()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)EnergyDeliveryAttribute10__1.builder().setDlvryIntrvl(timePeriodDetails1 == null ? Collections.emptyList() : Collections.singletonList(timePeriodDetails1)).setDlvryDt(DatePeriod1.builder().setFrDt((Date)item.map("getDeliveryStartDate", deliveryReport -> deliveryReport.getDeliveryStartDate()).get()).setToDt((Date)item.map("getDeliveryStartDate", deliveryReport -> deliveryReport.getDeliveryStartDate()).get()).build()).setDrtn((DurationType1Code)item.map("getDuration", deliveryReport -> deliveryReport.getDuration()).get()).setWkDay(item.mapC("getDaysOfTheWeek", deliveryReport -> deliveryReport.getDaysOfTheWeek()).mapItem(_item -> _item.checkedMap("to-enum", WeekDay3Code__1::fromDisplayName, IllegalArgumentException.class)).getMulti()).setDlvryCpcty(Quantity47Choice__1.builder().setQty((BigDecimal)item.map("getDeliveryCapacity", deliveryReport -> deliveryReport.getDeliveryCapacity()).get()).build()).setQtyUnit(EnergyQuantityUnit2Choice__1.builder().setCd((EnergyQuantityUnit2Code)item.map("getQuantityUnit", deliveryReport -> deliveryReport.getQuantityUnit()).get()).build()).setPricTmIntrvlQty(AmountAndDirection106__3.builder().setAmt(ActiveOrHistoricCurrencyAnd20Amount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPriceTimeIntervalQuantity", deliveryReport -> deliveryReport.getPriceTimeIntervalQuantity()).get())).setCcy((String)item.map("getCurrencyOfThePriceTimeIntervalQuantity", deliveryReport -> deliveryReport.getCurrencyOfThePriceTimeIntervalQuantity()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).build());
            }).getMulti()).build());
            return Optional.ofNullable(nrgySpcfcAttrbts).map(o -> o.prune()).orElse(null);
        }
    }
}

