/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import iso20022.auth030.jfsa.CreditDerivative4__1;
import iso20022.auth030.jfsa.DebtInstrumentSeniorityType2Code;
import iso20022.auth030.jfsa.DerivativePartyIdentification1Choice;
import iso20022.auth030.jfsa.Tranche3;
import iso20022.auth030.jfsa.TrancheIndicator3Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCdtDefault.class)
public abstract class GetCdt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CreditDerivative4__1 evaluate(JFSATransactionReport drrReport) {
        CreditDerivative4__1 cdt;
        CreditDerivative4__1.CreditDerivative4__1Builder cdtBuilder = this.doEvaluate(drrReport);
        if (cdtBuilder == null) {
            cdt = null;
        } else {
            cdt = cdtBuilder.build();
            this.objectValidator.validate(CreditDerivative4__1.class, (RosettaModelObject)cdt);
        }
        return cdt;
    }

    protected abstract CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(JFSATransactionReport var1);

    public static class GetCdtDefault
    extends GetCdt {
        @Override
        protected CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(JFSATransactionReport drrReport) {
            CreditDerivative4__1.CreditDerivative4__1Builder cdt = CreditDerivative4__1.builder();
            return this.assignOutput(cdt, drrReport);
        }

        protected CreditDerivative4__1.CreditDerivative4__1Builder assignOutput(CreditDerivative4__1.CreditDerivative4__1Builder cdt, JFSATransactionReport drrReport) {
            cdt = (CreditDerivative4__1.CreditDerivative4__1Builder)this.toBuilder((RosettaModelObject)CreditDerivative4__1.builder().setSnrty((DebtInstrumentSeniorityType2Code)MapperS.of((Object)drrReport).map("getSeniority", jFSATransactionReport -> jFSATransactionReport.getSeniority()).checkedMap("to-enum", DebtInstrumentSeniorityType2Code::fromDisplayName, IllegalArgumentException.class).get()).setRefPty(DerivativePartyIdentification1Choice.builder().setLei((String)MapperS.of((Object)drrReport).map("getReferenceEntity", jFSATransactionReport -> jFSATransactionReport.getReferenceEntity()).get()).build()).setSrs((Integer)MapperS.of((Object)drrReport).map("getSeries", jFSATransactionReport -> jFSATransactionReport.getSeries()).get()).setVrsn((Integer)MapperS.of((Object)drrReport).map("getVersion", jFSATransactionReport -> jFSATransactionReport.getVersion()).get()).setIndxFctr((BigDecimal)MapperS.of((Object)drrReport).map("getIndexFactor", jFSATransactionReport -> jFSATransactionReport.getIndexFactor()).get()).setTrch(TrancheIndicator3Choice__1.builder().setTrnchd(Tranche3.builder().setAttchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexAttachmentPoint", jFSATransactionReport -> jFSATransactionReport.getCdSIndexAttachmentPoint()).get()).setDtchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexDetachmentPoint", jFSATransactionReport -> jFSATransactionReport.getCdSIndexDetachmentPoint()).get()).build()).build()).build());
            return Optional.ofNullable(cdt).map(o -> o.prune()).orElse(null);
        }
    }
}

