/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;

@ImplementedBy(value=GetSttlmDtDefault.class)
public abstract class GetSttlmDt
implements RosettaFunction {
    public Date evaluate(JFSATransactionReport drrReport) {
        Date sttlmDt = this.doEvaluate(drrReport);
        return sttlmDt;
    }

    protected abstract Date doEvaluate(JFSATransactionReport var1);

    public static class GetSttlmDtDefault
    extends GetSttlmDt {
        @Override
        protected Date doEvaluate(JFSATransactionReport drrReport) {
            Date sttlmDt = null;
            return this.assignOutput(sttlmDt, drrReport);
        }

        protected Date assignOutput(Date sttlmDt, JFSATransactionReport drrReport) {
            sttlmDt = (Date)MapperS.of((Object)drrReport).map("getFinalContractualSettlementDate", jFSATransactionReport -> jFSATransactionReport.getFinalContractualSettlementDate()).get();
            return sttlmDt;
        }
    }
}

