/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.identifier.IdentifiedList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.standards.iosco.cde.reports.CDEPackageIdentifierRule;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=PackageIdentifierRuleDefault.class)
public abstract class PackageIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CDEPackageIdentifierRule cDEPackageIdentifierRule;
    @Inject
    protected GetPackageInformation getPackageInformation;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PackageIdentifierRuleDefault
    extends PackageIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.getPackageInformation.evaluate((ReportableEvent)item.get())));
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> MapperC.of(this.cDEPackageIdentifierRule.evaluate((IdentifiedList)item.get()).stream().map(string -> FieldWithMetaString.builder().setValue((String)string).build()).collect(Collectors.toList())));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg2.last().get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

