/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_1103_02")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1103_02
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_1103_02";
    public static final String DEFINITION = "if actionType = ActionTypeEnum -> VALU to-string then reportingTimestamp -> date >= valuationTimestamp -> date";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_1103_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_1103_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_1103_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1103_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_1103_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1103_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.VALU)).map("to-string", ActionTypeEnum::toDisplayString), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)aSICTransactionReport).map("getReportingTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getReportingTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getValuationTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getValuationTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

