/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_2010_01")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_2010_01
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_2010_01";
    public static final String DEFINITION = "if actionType = ActionTypeEnum -> VALU to-string then if smallScaleBuySideEntityIndicator <> \"SSBS\" then delta exists else if [\"OPTN\", \"SWPT\"] any <> contractType then delta is absent";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_2010_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_2010_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_2010_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_2010_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_2010_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_2010_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.VALU)).map("to-string", ActionTypeEnum::toDisplayString), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getSmallScaleBuySideEntityIndicator", _aSICTransactionReport -> _aSICTransactionReport.getSmallScaleBuySideEntityIndicator()), (Mapper)MapperS.of((Object)"SSBS"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getDelta", _aSICTransactionReport -> _aSICTransactionReport.getDelta()));
                    }
                    if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)"OPTN"), MapperS.of((Object)"SWPT")}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getDelta", _aSICTransactionReport -> _aSICTransactionReport.getDelta()));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

