/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportPriorUti")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportPriorUti
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportPriorUti";
    public static final String DEFINITION = "if actionType = ActionTypeEnum -> NEWT to-string and [ EventTypeEnum -> NOVA to-string, EventTypeEnum -> EXER to-string, EventTypeEnum -> ALOC to-string, EventTypeEnum -> CLRG to-string, EventTypeEnum -> CLAL to-string ] any = eventType then required choice priorUTI, priorUtiProprietary";

    public static class NoOp
    implements ASICTransactionReportPriorUti {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportPriorUti {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportPriorUti.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportPriorUti.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportPriorUti.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportPriorUti.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)).map("to-string", ActionTypeEnum::toDisplayString), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.NOVA)).map("to-string", EventTypeEnum::toDisplayString), MapperS.of((Object)((Object)EventTypeEnum.EXER)).map("to-string", EventTypeEnum::toDisplayString), MapperS.of((Object)((Object)EventTypeEnum.ALOC)).map("to-string", EventTypeEnum::toDisplayString), MapperS.of((Object)((Object)EventTypeEnum.CLRG)).map("to-string", EventTypeEnum::toDisplayString), MapperS.of((Object)((Object)EventTypeEnum.CLAL)).map("to-string", EventTypeEnum::toDisplayString)}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getEventType", _aSICTransactionReport -> _aSICTransactionReport.getEventType()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)aSICTransactionReport), Arrays.asList("priorUTI", "priorUtiProprietary"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

