/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.valuation.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.valuation.ASICValuationReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ASICValuationReportTypeFormatValidator
implements Validator<ASICValuationReport> {
    private List<ComparisonResult> getComparisonResults(ASICValuationReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"utiProprietaryID", (String)o.getUtiProprietaryID(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperatorsNullSafe.checkString((String)"reportingEntity", (String)o.getReportingEntity(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"executionAgentOfTheCounterparty1", (String)o.getExecutionAgentOfTheCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"executionAgentOfTheCounterparty2", (String)o.getExecutionAgentOfTheCounterparty2(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICValuationReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"ASICValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICValuationReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"ASICValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICValuationReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

