/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOne18Rate;
import drr.standards.iosco.cde.reports.CDEExchangeRateRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateLeg1RuleDefault.class)
public abstract class ExchangeRateLeg1Rule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected CDEExchangeRateRule cDEExchangeRateRule;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class ExchangeRateLeg1RuleDefault
    extends ExchangeRateLeg1Rule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.cDEExchangeRateRule.evaluate(input));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOne18Rate.evaluate((BigDecimal)thenArg1.get())).get();
            return output;
        }
    }
}

