/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.IsCreditDefaultSwapIndex;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=IndexFactorRuleDefault.class)
public abstract class IndexFactorRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected FormatToBaseOneRate formatToBaseOneRate;
    @Inject
    protected IsCreditDefaultSwapIndex isCreditDefaultSwapIndex;
    @Inject
    protected TradeForEvent tradeForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class IndexFactorRuleDefault
    extends IndexFactorRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> this.isCreditDefaultSwapIndex.evaluate((Trade)item.get()));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getIndexFactor", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexFactor()));
            output = (BigDecimal)MapperS.of((Object)this.formatToBaseOneRate.evaluate((BigDecimal)thenArg2.get())).get();
            return output;
        }
    }
}

