/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.tr.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCommoditySwaption;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.reports.CDEExpirationDateRule;
import javax.inject.Inject;

@ImplementedBy(value=MaturityDateOfTheUnderlierRuleDefault.class)
public abstract class MaturityDateOfTheUnderlierRule
implements ReportFunction<TransactionReportInstruction, Date> {
    @Inject
    protected CDEExpirationDateRule cDEExpirationDateRule;
    @Inject
    protected IsCommoditySwaption isCommoditySwaption;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Date evaluate(TransactionReportInstruction input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    public static class MaturityDateOfTheUnderlierRuleDefault
    extends MaturityDateOfTheUnderlierRule {
        @Override
        protected Date doEvaluate(TransactionReportInstruction input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isIRSwaption.evaluate((Product)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCreditSwaption.evaluate((Product)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwaption.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.underlierForProduct.evaluate((Product)item.get()));
                }
                return MapperS.ofNull();
            });
            output = (Date)thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.cDEExpirationDateRule.evaluate((Product)item.get()))).get();
            return output;
        }
    }
}

