/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.meta.ReportableDeliveryMeta;
import iso20022.auth030.esma.DurationType1Code;
import iso20022.auth030.esma.EnergyQuantityUnit2Code;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportableDelivery", builder=ReportableDeliveryBuilderImpl.class, version="5.57.0")
@RuneDataType(value="ReportableDelivery", model="drr", builder=ReportableDeliveryBuilderImpl.class, version="5.57.0")
public interface ReportableDelivery
extends RosettaModelObject {
    public static final ReportableDeliveryMeta metaData = new ReportableDeliveryMeta();

    public LocalTime getDeliveryStartTime();

    public LocalTime getDeliveryEndTime();

    public Date getDeliveryStartDate();

    public Date getDeliveryEndDate();

    public DurationType1Code getDuration();

    public List<String> getDaysOfTheWeek();

    public BigDecimal getDeliveryCapacity();

    public EnergyQuantityUnit2Code getQuantityUnit();

    public BigDecimal getPriceTimeIntervalQuantity();

    public String getCurrencyOfThePriceTimeIntervalQuantity();

    public ReportableDelivery build();

    public ReportableDeliveryBuilder toBuilder();

    public static ReportableDeliveryBuilder builder() {
        return new ReportableDeliveryBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportableDelivery> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportableDelivery> getType() {
        return ReportableDelivery.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("deliveryStartTime"), LocalTime.class, (Object)this.getDeliveryStartTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryEndTime"), LocalTime.class, (Object)this.getDeliveryEndTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryStartDate"), Date.class, (Object)this.getDeliveryStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryEndDate"), Date.class, (Object)this.getDeliveryEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("duration"), DurationType1Code.class, (Object)this.getDuration(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("daysOfTheWeek"), String.class, this.getDaysOfTheWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryCapacity"), BigDecimal.class, (Object)this.getDeliveryCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnit"), EnergyQuantityUnit2Code.class, (Object)this.getQuantityUnit(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceTimeIntervalQuantity"), BigDecimal.class, (Object)this.getPriceTimeIntervalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfThePriceTimeIntervalQuantity"), String.class, (Object)this.getCurrencyOfThePriceTimeIntervalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ReportableDeliveryBuilderImpl
    implements ReportableDeliveryBuilder {
        protected LocalTime deliveryStartTime;
        protected LocalTime deliveryEndTime;
        protected Date deliveryStartDate;
        protected Date deliveryEndDate;
        protected DurationType1Code duration;
        protected List<String> daysOfTheWeek = new ArrayList<String>();
        protected BigDecimal deliveryCapacity;
        protected EnergyQuantityUnit2Code quantityUnit;
        protected BigDecimal priceTimeIntervalQuantity;
        protected String currencyOfThePriceTimeIntervalQuantity;

        @Override
        @RosettaAttribute(value="deliveryStartTime")
        @RuneAttribute(value="deliveryStartTime")
        public LocalTime getDeliveryStartTime() {
            return this.deliveryStartTime;
        }

        @Override
        @RosettaAttribute(value="deliveryEndTime")
        @RuneAttribute(value="deliveryEndTime")
        public LocalTime getDeliveryEndTime() {
            return this.deliveryEndTime;
        }

        @Override
        @RosettaAttribute(value="deliveryStartDate")
        @RuneAttribute(value="deliveryStartDate")
        public Date getDeliveryStartDate() {
            return this.deliveryStartDate;
        }

        @Override
        @RosettaAttribute(value="deliveryEndDate")
        @RuneAttribute(value="deliveryEndDate")
        public Date getDeliveryEndDate() {
            return this.deliveryEndDate;
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public DurationType1Code getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="daysOfTheWeek")
        @RuneAttribute(value="daysOfTheWeek")
        public List<String> getDaysOfTheWeek() {
            return this.daysOfTheWeek;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public BigDecimal getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        @RosettaAttribute(value="quantityUnit")
        @RuneAttribute(value="quantityUnit")
        public EnergyQuantityUnit2Code getQuantityUnit() {
            return this.quantityUnit;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public BigDecimal getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        @RosettaAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        @RuneAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        public String getCurrencyOfThePriceTimeIntervalQuantity() {
            return this.currencyOfThePriceTimeIntervalQuantity;
        }

        @Override
        @RosettaAttribute(value="deliveryStartTime")
        @RuneAttribute(value="deliveryStartTime")
        public ReportableDeliveryBuilder setDeliveryStartTime(LocalTime _deliveryStartTime) {
            this.deliveryStartTime = _deliveryStartTime == null ? null : _deliveryStartTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryEndTime")
        @RuneAttribute(value="deliveryEndTime")
        public ReportableDeliveryBuilder setDeliveryEndTime(LocalTime _deliveryEndTime) {
            this.deliveryEndTime = _deliveryEndTime == null ? null : _deliveryEndTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryStartDate")
        @RuneAttribute(value="deliveryStartDate")
        public ReportableDeliveryBuilder setDeliveryStartDate(Date _deliveryStartDate) {
            this.deliveryStartDate = _deliveryStartDate == null ? null : _deliveryStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryEndDate")
        @RuneAttribute(value="deliveryEndDate")
        public ReportableDeliveryBuilder setDeliveryEndDate(Date _deliveryEndDate) {
            this.deliveryEndDate = _deliveryEndDate == null ? null : _deliveryEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public ReportableDeliveryBuilder setDuration(DurationType1Code _duration) {
            this.duration = _duration == null ? null : _duration;
            return this;
        }

        @Override
        @RosettaAttribute(value="daysOfTheWeek")
        @RuneAttribute(value="daysOfTheWeek")
        public ReportableDeliveryBuilder addDaysOfTheWeek(String _daysOfTheWeek) {
            if (_daysOfTheWeek != null) {
                this.daysOfTheWeek.add(_daysOfTheWeek);
            }
            return this;
        }

        @Override
        public ReportableDeliveryBuilder addDaysOfTheWeek(String _daysOfTheWeek, int idx) {
            this.getIndex(this.daysOfTheWeek, idx, () -> _daysOfTheWeek);
            return this;
        }

        @Override
        public ReportableDeliveryBuilder addDaysOfTheWeek(List<String> daysOfTheWeeks) {
            if (daysOfTheWeeks != null) {
                for (String toAdd : daysOfTheWeeks) {
                    this.daysOfTheWeek.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="daysOfTheWeek")
        public ReportableDeliveryBuilder setDaysOfTheWeek(List<String> daysOfTheWeeks) {
            this.daysOfTheWeek = daysOfTheWeeks == null ? new ArrayList<String>() : (List)daysOfTheWeeks.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public ReportableDeliveryBuilder setDeliveryCapacity(BigDecimal _deliveryCapacity) {
            this.deliveryCapacity = _deliveryCapacity == null ? null : _deliveryCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnit")
        @RuneAttribute(value="quantityUnit")
        public ReportableDeliveryBuilder setQuantityUnit(EnergyQuantityUnit2Code _quantityUnit) {
            this.quantityUnit = _quantityUnit == null ? null : _quantityUnit;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public ReportableDeliveryBuilder setPriceTimeIntervalQuantity(BigDecimal _priceTimeIntervalQuantity) {
            this.priceTimeIntervalQuantity = _priceTimeIntervalQuantity == null ? null : _priceTimeIntervalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        @RuneAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        public ReportableDeliveryBuilder setCurrencyOfThePriceTimeIntervalQuantity(String _currencyOfThePriceTimeIntervalQuantity) {
            this.currencyOfThePriceTimeIntervalQuantity = _currencyOfThePriceTimeIntervalQuantity == null ? null : _currencyOfThePriceTimeIntervalQuantity;
            return this;
        }

        @Override
        public ReportableDelivery build() {
            return new ReportableDeliveryImpl(this);
        }

        @Override
        public ReportableDeliveryBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportableDeliveryBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryStartTime() != null) {
                return true;
            }
            if (this.getDeliveryEndTime() != null) {
                return true;
            }
            if (this.getDeliveryStartDate() != null) {
                return true;
            }
            if (this.getDeliveryEndDate() != null) {
                return true;
            }
            if (this.getDuration() != null) {
                return true;
            }
            if (this.getDaysOfTheWeek() != null && !this.getDaysOfTheWeek().isEmpty()) {
                return true;
            }
            if (this.getDeliveryCapacity() != null) {
                return true;
            }
            if (this.getQuantityUnit() != null) {
                return true;
            }
            if (this.getPriceTimeIntervalQuantity() != null) {
                return true;
            }
            return this.getCurrencyOfThePriceTimeIntervalQuantity() != null;
        }

        public ReportableDeliveryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportableDeliveryBuilder o = (ReportableDeliveryBuilder)other;
            merger.mergeBasic((Object)this.getDeliveryStartTime(), (Object)o.getDeliveryStartTime(), this::setDeliveryStartTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryEndTime(), (Object)o.getDeliveryEndTime(), this::setDeliveryEndTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryStartDate(), (Object)o.getDeliveryStartDate(), this::setDeliveryStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryEndDate(), (Object)o.getDeliveryEndDate(), this::setDeliveryEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDuration(), (Object)o.getDuration(), this::setDuration, new AttributeMeta[0]);
            merger.mergeBasic(this.getDaysOfTheWeek(), o.getDaysOfTheWeek(), this::addDaysOfTheWeek);
            merger.mergeBasic((Object)this.getDeliveryCapacity(), (Object)o.getDeliveryCapacity(), this::setDeliveryCapacity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getQuantityUnit(), (Object)o.getQuantityUnit(), this::setQuantityUnit, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceTimeIntervalQuantity(), (Object)o.getPriceTimeIntervalQuantity(), this::setPriceTimeIntervalQuantity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfThePriceTimeIntervalQuantity(), (Object)o.getCurrencyOfThePriceTimeIntervalQuantity(), this::setCurrencyOfThePriceTimeIntervalQuantity, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryStartTime, _that.getDeliveryStartTime())) {
                return false;
            }
            if (!Objects.equals(this.deliveryEndTime, _that.getDeliveryEndTime())) {
                return false;
            }
            if (!Objects.equals(this.deliveryStartDate, _that.getDeliveryStartDate())) {
                return false;
            }
            if (!Objects.equals(this.deliveryEndDate, _that.getDeliveryEndDate())) {
                return false;
            }
            if (!Objects.equals(this.duration, _that.getDuration())) {
                return false;
            }
            if (!ListEquals.listEquals(this.daysOfTheWeek, _that.getDaysOfTheWeek())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnit, _that.getQuantityUnit())) {
                return false;
            }
            if (!Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity())) {
                return false;
            }
            return Objects.equals(this.currencyOfThePriceTimeIntervalQuantity, _that.getCurrencyOfThePriceTimeIntervalQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryStartTime != null ? this.deliveryStartTime.hashCode() : 0);
            _result = 31 * _result + (this.deliveryEndTime != null ? this.deliveryEndTime.hashCode() : 0);
            _result = 31 * _result + (this.deliveryStartDate != null ? this.deliveryStartDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryEndDate != null ? this.deliveryEndDate.hashCode() : 0);
            _result = 31 * _result + (this.duration != null ? this.duration.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.daysOfTheWeek != null ? this.daysOfTheWeek.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnit != null ? this.quantityUnit.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfThePriceTimeIntervalQuantity != null ? this.currencyOfThePriceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableDeliveryBuilder {deliveryStartTime=" + String.valueOf(this.deliveryStartTime) + ", deliveryEndTime=" + String.valueOf(this.deliveryEndTime) + ", deliveryStartDate=" + String.valueOf(this.deliveryStartDate) + ", deliveryEndDate=" + String.valueOf(this.deliveryEndDate) + ", duration=" + String.valueOf(this.duration) + ", daysOfTheWeek=" + String.valueOf(this.daysOfTheWeek) + ", deliveryCapacity=" + String.valueOf(this.deliveryCapacity) + ", quantityUnit=" + String.valueOf(this.quantityUnit) + ", priceTimeIntervalQuantity=" + String.valueOf(this.priceTimeIntervalQuantity) + ", currencyOfThePriceTimeIntervalQuantity=" + this.currencyOfThePriceTimeIntervalQuantity + "}";
        }
    }

    public static interface ReportableDeliveryBuilder
    extends ReportableDelivery,
    RosettaModelObjectBuilder {
        public ReportableDeliveryBuilder setDeliveryStartTime(LocalTime var1);

        public ReportableDeliveryBuilder setDeliveryEndTime(LocalTime var1);

        public ReportableDeliveryBuilder setDeliveryStartDate(Date var1);

        public ReportableDeliveryBuilder setDeliveryEndDate(Date var1);

        public ReportableDeliveryBuilder setDuration(DurationType1Code var1);

        public ReportableDeliveryBuilder addDaysOfTheWeek(String var1);

        public ReportableDeliveryBuilder addDaysOfTheWeek(String var1, int var2);

        public ReportableDeliveryBuilder addDaysOfTheWeek(List<String> var1);

        public ReportableDeliveryBuilder setDaysOfTheWeek(List<String> var1);

        public ReportableDeliveryBuilder setDeliveryCapacity(BigDecimal var1);

        public ReportableDeliveryBuilder setQuantityUnit(EnergyQuantityUnit2Code var1);

        public ReportableDeliveryBuilder setPriceTimeIntervalQuantity(BigDecimal var1);

        public ReportableDeliveryBuilder setCurrencyOfThePriceTimeIntervalQuantity(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("deliveryStartTime"), LocalTime.class, (Object)this.getDeliveryStartTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryEndTime"), LocalTime.class, (Object)this.getDeliveryEndTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryStartDate"), Date.class, (Object)this.getDeliveryStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryEndDate"), Date.class, (Object)this.getDeliveryEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("duration"), DurationType1Code.class, (Object)this.getDuration(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("daysOfTheWeek"), String.class, this.getDaysOfTheWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryCapacity"), BigDecimal.class, (Object)this.getDeliveryCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnit"), EnergyQuantityUnit2Code.class, (Object)this.getQuantityUnit(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceTimeIntervalQuantity"), BigDecimal.class, (Object)this.getPriceTimeIntervalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfThePriceTimeIntervalQuantity"), String.class, (Object)this.getCurrencyOfThePriceTimeIntervalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ReportableDeliveryBuilder prune();
    }

    public static class ReportableDeliveryImpl
    implements ReportableDelivery {
        private final LocalTime deliveryStartTime;
        private final LocalTime deliveryEndTime;
        private final Date deliveryStartDate;
        private final Date deliveryEndDate;
        private final DurationType1Code duration;
        private final List<String> daysOfTheWeek;
        private final BigDecimal deliveryCapacity;
        private final EnergyQuantityUnit2Code quantityUnit;
        private final BigDecimal priceTimeIntervalQuantity;
        private final String currencyOfThePriceTimeIntervalQuantity;

        protected ReportableDeliveryImpl(ReportableDeliveryBuilder builder) {
            this.deliveryStartTime = builder.getDeliveryStartTime();
            this.deliveryEndTime = builder.getDeliveryEndTime();
            this.deliveryStartDate = builder.getDeliveryStartDate();
            this.deliveryEndDate = builder.getDeliveryEndDate();
            this.duration = builder.getDuration();
            this.daysOfTheWeek = Optional.ofNullable(builder.getDaysOfTheWeek()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.deliveryCapacity = builder.getDeliveryCapacity();
            this.quantityUnit = builder.getQuantityUnit();
            this.priceTimeIntervalQuantity = builder.getPriceTimeIntervalQuantity();
            this.currencyOfThePriceTimeIntervalQuantity = builder.getCurrencyOfThePriceTimeIntervalQuantity();
        }

        @Override
        @RosettaAttribute(value="deliveryStartTime")
        @RuneAttribute(value="deliveryStartTime")
        public LocalTime getDeliveryStartTime() {
            return this.deliveryStartTime;
        }

        @Override
        @RosettaAttribute(value="deliveryEndTime")
        @RuneAttribute(value="deliveryEndTime")
        public LocalTime getDeliveryEndTime() {
            return this.deliveryEndTime;
        }

        @Override
        @RosettaAttribute(value="deliveryStartDate")
        @RuneAttribute(value="deliveryStartDate")
        public Date getDeliveryStartDate() {
            return this.deliveryStartDate;
        }

        @Override
        @RosettaAttribute(value="deliveryEndDate")
        @RuneAttribute(value="deliveryEndDate")
        public Date getDeliveryEndDate() {
            return this.deliveryEndDate;
        }

        @Override
        @RosettaAttribute(value="duration")
        @RuneAttribute(value="duration")
        public DurationType1Code getDuration() {
            return this.duration;
        }

        @Override
        @RosettaAttribute(value="daysOfTheWeek")
        @RuneAttribute(value="daysOfTheWeek")
        public List<String> getDaysOfTheWeek() {
            return this.daysOfTheWeek;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        @RuneAttribute(value="deliveryCapacity")
        public BigDecimal getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        @RosettaAttribute(value="quantityUnit")
        @RuneAttribute(value="quantityUnit")
        public EnergyQuantityUnit2Code getQuantityUnit() {
            return this.quantityUnit;
        }

        @Override
        @RosettaAttribute(value="priceTimeIntervalQuantity")
        @RuneAttribute(value="priceTimeIntervalQuantity")
        public BigDecimal getPriceTimeIntervalQuantity() {
            return this.priceTimeIntervalQuantity;
        }

        @Override
        @RosettaAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        @RuneAttribute(value="currencyOfThePriceTimeIntervalQuantity")
        public String getCurrencyOfThePriceTimeIntervalQuantity() {
            return this.currencyOfThePriceTimeIntervalQuantity;
        }

        @Override
        public ReportableDelivery build() {
            return this;
        }

        @Override
        public ReportableDeliveryBuilder toBuilder() {
            ReportableDeliveryBuilder builder = ReportableDelivery.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportableDeliveryBuilder builder) {
            Optional.ofNullable(this.getDeliveryStartTime()).ifPresent(builder::setDeliveryStartTime);
            Optional.ofNullable(this.getDeliveryEndTime()).ifPresent(builder::setDeliveryEndTime);
            Optional.ofNullable(this.getDeliveryStartDate()).ifPresent(builder::setDeliveryStartDate);
            Optional.ofNullable(this.getDeliveryEndDate()).ifPresent(builder::setDeliveryEndDate);
            Optional.ofNullable(this.getDuration()).ifPresent(builder::setDuration);
            Optional.ofNullable(this.getDaysOfTheWeek()).ifPresent(builder::setDaysOfTheWeek);
            Optional.ofNullable(this.getDeliveryCapacity()).ifPresent(builder::setDeliveryCapacity);
            Optional.ofNullable(this.getQuantityUnit()).ifPresent(builder::setQuantityUnit);
            Optional.ofNullable(this.getPriceTimeIntervalQuantity()).ifPresent(builder::setPriceTimeIntervalQuantity);
            Optional.ofNullable(this.getCurrencyOfThePriceTimeIntervalQuantity()).ifPresent(builder::setCurrencyOfThePriceTimeIntervalQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableDelivery _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryStartTime, _that.getDeliveryStartTime())) {
                return false;
            }
            if (!Objects.equals(this.deliveryEndTime, _that.getDeliveryEndTime())) {
                return false;
            }
            if (!Objects.equals(this.deliveryStartDate, _that.getDeliveryStartDate())) {
                return false;
            }
            if (!Objects.equals(this.deliveryEndDate, _that.getDeliveryEndDate())) {
                return false;
            }
            if (!Objects.equals(this.duration, _that.getDuration())) {
                return false;
            }
            if (!ListEquals.listEquals(this.daysOfTheWeek, _that.getDaysOfTheWeek())) {
                return false;
            }
            if (!Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity())) {
                return false;
            }
            if (!Objects.equals(this.quantityUnit, _that.getQuantityUnit())) {
                return false;
            }
            if (!Objects.equals(this.priceTimeIntervalQuantity, _that.getPriceTimeIntervalQuantity())) {
                return false;
            }
            return Objects.equals(this.currencyOfThePriceTimeIntervalQuantity, _that.getCurrencyOfThePriceTimeIntervalQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryStartTime != null ? this.deliveryStartTime.hashCode() : 0);
            _result = 31 * _result + (this.deliveryEndTime != null ? this.deliveryEndTime.hashCode() : 0);
            _result = 31 * _result + (this.deliveryStartDate != null ? this.deliveryStartDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryEndDate != null ? this.deliveryEndDate.hashCode() : 0);
            _result = 31 * _result + (this.duration != null ? this.duration.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.daysOfTheWeek != null ? this.daysOfTheWeek.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            _result = 31 * _result + (this.quantityUnit != null ? this.quantityUnit.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceTimeIntervalQuantity != null ? this.priceTimeIntervalQuantity.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfThePriceTimeIntervalQuantity != null ? this.currencyOfThePriceTimeIntervalQuantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableDelivery {deliveryStartTime=" + String.valueOf(this.deliveryStartTime) + ", deliveryEndTime=" + String.valueOf(this.deliveryEndTime) + ", deliveryStartDate=" + String.valueOf(this.deliveryStartDate) + ", deliveryEndDate=" + String.valueOf(this.deliveryEndDate) + ", duration=" + String.valueOf(this.duration) + ", daysOfTheWeek=" + String.valueOf(this.daysOfTheWeek) + ", deliveryCapacity=" + String.valueOf(this.deliveryCapacity) + ", quantityUnit=" + String.valueOf(this.quantityUnit) + ", priceTimeIntervalQuantity=" + String.valueOf(this.priceTimeIntervalQuantity) + ", currencyOfThePriceTimeIntervalQuantity=" + this.currencyOfThePriceTimeIntervalQuantity + "}";
        }
    }
}

