/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.Measure;
import cdm.base.math.UnitType;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.observable.asset.Price;
import cdm.product.template.OptionPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ETDNotionalOptionDefault.class)
public abstract class ETDNotionalOption
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Measure evaluate(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
        Measure notional;
        Measure.MeasureBuilder notionalBuilder = this.doEvaluate(optionPayout, tradeLot);
        if (notionalBuilder == null) {
            notional = null;
        } else {
            notional = notionalBuilder.build();
            this.objectValidator.validate(Measure.class, (RosettaModelObject)notional);
        }
        return notional;
    }

    protected abstract Measure.MeasureBuilder doEvaluate(OptionPayout var1, List<? extends TradeLot> var2);

    protected abstract MapperS<BigDecimal> quantityCurrency(OptionPayout var1, List<? extends TradeLot> var2);

    protected abstract MapperS<BigDecimal> quantityFinancial(OptionPayout var1, List<? extends TradeLot> var2);

    protected abstract MapperS<? extends Price> strikePrice(OptionPayout var1, List<? extends TradeLot> var2);

    protected abstract MapperS<BigDecimal> amount(OptionPayout var1, List<? extends TradeLot> var2);

    protected abstract MapperS<? extends UnitType> amountUnit(OptionPayout var1, List<? extends TradeLot> var2);

    public static class ETDNotionalOptionDefault
    extends ETDNotionalOption {
        @Override
        protected Measure.MeasureBuilder doEvaluate(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            if (tradeLot == null) {
                tradeLot = Collections.emptyList();
            }
            Measure.MeasureBuilder notional = Measure.builder();
            return this.assignOutput(notional, optionPayout, tradeLot);
        }

        protected Measure.MeasureBuilder assignOutput(Measure.MeasureBuilder notional, OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            notional = (Measure.MeasureBuilder)this.toBuilder((RosettaModelObject)Measure.builder().setValue((BigDecimal)this.amount(optionPayout, tradeLot).get()).setUnit((UnitType)this.amountUnit(optionPayout, tradeLot).get()).build());
            return Optional.ofNullable(notional).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> quantityCurrency(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<BigDecimal> quantityFinancial(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<? extends Price> strikePrice(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            return MapperS.of((Object)optionPayout).map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice());
        }

        @Override
        protected MapperS<BigDecimal> amount(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.quantityCurrency(optionPayout, tradeLot);
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperMaths.multiply(this.quantityFinancial(optionPayout, tradeLot), (Mapper)this.strikePrice(optionPayout, tradeLot).map("getValue", price -> price.getValue()));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends UnitType> amountUnit(OptionPayout optionPayout, List<? extends TradeLot> tradeLot) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(tradeLot).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity());
                MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
                MapperS thenArg2 = MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg1.get()));
                return thenArg2.mapSingleToItem(item -> item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()));
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)((TradeLot)MapperC.of(tradeLot).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.strikePrice(optionPayout, tradeLot).map("getUnit", price -> price.getUnit());
            }
            return MapperS.ofNull();
        }
    }
}

