/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=GetProductQualifierDefault.class)
public abstract class GetProductQualifier
implements RosettaFunction {
    public String evaluate(List<? extends ProductTaxonomy> productTaxonomy) {
        String qualifier = this.doEvaluate(productTaxonomy);
        return qualifier;
    }

    protected abstract String doEvaluate(List<? extends ProductTaxonomy> var1);

    public static class GetProductQualifierDefault
    extends GetProductQualifier {
        @Override
        protected String doEvaluate(List<? extends ProductTaxonomy> productTaxonomy) {
            if (productTaxonomy == null) {
                productTaxonomy = Collections.emptyList();
            }
            String qualifier = null;
            return this.assignOutput(qualifier, productTaxonomy);
        }

        protected String assignOutput(String qualifier, List<? extends ProductTaxonomy> productTaxonomy) {
            MapperC thenArg = MapperC.of(productTaxonomy).mapItem(item -> item.map("getProductQualifier", _productTaxonomy -> _productTaxonomy.getProductQualifier()));
            qualifier = (String)MapperS.of((Object)((String)thenArg.get())).get();
            return qualifier;
        }
    }
}

