/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.schedule.CalculationPeriodDates;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=QuantityFrequencyOrCalculationPeriodDefault.class)
public abstract class QuantityFrequencyOrCalculationPeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Frequency evaluate(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
        Frequency frequency;
        Frequency.FrequencyBuilder frequencyBuilder = this.doEvaluate(calculationPeriodDates, priceQuantity);
        if (frequencyBuilder == null) {
            frequency = null;
        } else {
            frequency = frequencyBuilder.build();
            this.objectValidator.validate(Frequency.class, (RosettaModelObject)frequency);
        }
        return frequency;
    }

    protected abstract Frequency.FrequencyBuilder doEvaluate(CalculationPeriodDates var1, PriceQuantity var2);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(CalculationPeriodDates var1, PriceQuantity var2);

    public static class QuantityFrequencyOrCalculationPeriodDefault
    extends QuantityFrequencyOrCalculationPeriod {
        @Override
        protected Frequency.FrequencyBuilder doEvaluate(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
            Frequency.FrequencyBuilder frequency = Frequency.builder();
            return this.assignOutput(frequency, calculationPeriodDates, priceQuantity);
        }

        protected Frequency.FrequencyBuilder assignOutput(Frequency.FrequencyBuilder frequency, CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
            frequency = ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)((PeriodExtendedEnum)this.quantity(calculationPeriodDates, priceQuantity).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).map("getPeriod", _frequency -> _frequency.getPeriod()).get())), (Mapper)MapperS.of((Object)PeriodExtendedEnum.C), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)) != false ? (Frequency.FrequencyBuilder)this.toBuilder((RosettaModelObject)this.quantity(calculationPeriodDates, priceQuantity).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).get()) : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((PeriodExtendedEnum)this.quantity(calculationPeriodDates, priceQuantity).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency()).map("getPeriod", _frequency -> _frequency.getPeriod()).get())), (Mapper)MapperS.of((Object)PeriodExtendedEnum.C), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (Frequency.FrequencyBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)calculationPeriodDates).map("getCalculationPeriodFrequency", _calculationPeriodDates -> _calculationPeriodDates.getCalculationPeriodFrequency()).get()) : null);
            return Optional.ofNullable(frequency).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(CalculationPeriodDates calculationPeriodDates, PriceQuantity priceQuantity) {
            return MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).get());
        }
    }
}

