/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=UnderlierForProductDefault.class)
public abstract class UnderlierForProduct
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public Product evaluate(Product product) {
        Product underlierProduct;
        Product.ProductBuilder underlierProductBuilder = this.doEvaluate(product);
        if (underlierProductBuilder == null) {
            underlierProduct = null;
        } else {
            underlierProduct = underlierProductBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)underlierProduct);
        }
        return underlierProduct;
    }

    protected abstract Product.ProductBuilder doEvaluate(Product var1);

    public static class UnderlierForProductDefault
    extends UnderlierForProduct {
        @Override
        protected Product.ProductBuilder doEvaluate(Product product) {
            Product.ProductBuilder underlierProduct = Product.builder();
            return this.assignOutput(underlierProduct, product);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder underlierProduct, Product product) {
            underlierProduct = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((OptionPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).get()) : null);
            return Optional.ofNullable(underlierProduct).map(o -> o.prune()).orElse(null);
        }
    }
}

