/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.processor;

import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import drr.regulation.common.ReportableInformation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntragroupMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntragroupMappingProcessor.class);
    public static final String DTCC_INTRAGROUP_SCHEME = "http://www.dtcc.com/intragroup";

    public IntragroupMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path xmlPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        Boolean intragroup = this.determineIntragroup(xmlPath);
        if (intragroup != null) {
            ReportableInformation.ReportableInformationBuilder reportableInformationBuilder = (ReportableInformation.ReportableInformationBuilder)parent;
            reportableInformationBuilder.setIntragroup(intragroup);
        }
    }

    private Boolean determineIntragroup(Path xmlPath) {
        Boolean intragroup = this.isIntragroupByCategory(xmlPath);
        if (intragroup != null) {
            return intragroup;
        }
        return this.isIntragroupByTradePartyRelationshipType(xmlPath);
    }

    private Boolean isIntragroupByCategory(Path xmlPath) {
        List categoryPaths = this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(new String[]{"category"})).map(Mapping::getXmlPath).collect(Collectors.toList());
        for (Path categoryPath : categoryPaths) {
            List categoryElements = categoryPath.getElements();
            Optional<Boolean> isDtccIntragroupScheme = categoryElements.stream().filter(element -> element.getPathName().equals("category")).filter(element -> element.getMetas().containsKey("categoryScheme")).filter(element -> {
                String categoryScheme = (String)element.getMetas().get("categoryScheme");
                return categoryScheme != null && categoryScheme.equals(DTCC_INTRAGROUP_SCHEME);
            }).map(element -> true).findFirst();
            Optional<Boolean> isTrueValue = categoryElements.stream().filter(element -> element.getPathName().equals("category")).map(element -> {
                Optional mappedValue = MappingProcessorUtils.getNonNullMappedValue((Path)categoryPath, (List)this.getMappings());
                return mappedValue.isPresent() && ((String)mappedValue.get()).equals("true");
            }).findFirst();
            if (isDtccIntragroupScheme.isPresent() && isTrueValue.isPresent()) {
                return isDtccIntragroupScheme.get() != false && isTrueValue.get() != false;
            }
            if (!isDtccIntragroupScheme.isPresent()) continue;
            return isDtccIntragroupScheme.get();
        }
        return null;
    }

    private Boolean isIntragroupByTradePartyRelationshipType(Path xmlPath) {
        List tradePartyRelationshipTypePaths = this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(new String[]{"tradePartyRelationshipType"})).map(Mapping::getXmlPath).collect(Collectors.toList());
        for (Path tradePartyRelationshipTypePath : tradePartyRelationshipTypePaths) {
            String tradePartyRelationshipType = MappingProcessorUtils.getNonNullMappedValue((Path)tradePartyRelationshipTypePath, (List)this.getMappings()).orElse(null);
            if (!"Intragroup".equals(tradePartyRelationshipType)) continue;
            return true;
        }
        return null;
    }
}

