/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.lei.functions.LeiRegistrationStatusIsValid;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_1009_02")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_1009_02
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_1009_02";
    public static final String DEFINITION = "if counterparty2IdentifierType = True and [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> VALU to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> POSC to-string ] any = actionType then LeiRegistrationStatusIsValid( nonReportable -> enrichment -> leiData, counterparty2, eventDate, reportingTimestamp -> date )";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_1009_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_1009_02 {
        @Inject
        protected LeiRegistrationStatusIsValid leiRegistrationStatusIsValid;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_1009_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1009_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_1009_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1009_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getCounterparty2IdentifierType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getCounterparty2IdentifierType()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of((Object)((Object)ActionTypeEnum.MODI)).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of((Object)((Object)ActionTypeEnum.VALU)).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of((Object)((Object)ActionTypeEnum.CORR)).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of((Object)((Object)ActionTypeEnum.POSC)).map("to-string", ActionTypeEnum::toDisplayString)}), (Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.leiRegistrationStatusIsValid.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", eSMAEMIRNonReportable -> eSMAEMIRNonReportable.getEnrichment()).mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getCounterparty2", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getCounterparty2()).get(), (Date)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEventDate", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEventDate()).get(), (Date)MapperS.of((Object)eSMAEMIRTransactionReport).map("getReportingTimestamp", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getReportingTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

