/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.Create_ContinuousQuantitySchedule;
import drr.regulation.common.functions.GetExpirationDate;
import drr.regulation.common.functions.GetLeg1ResolvablePriceQuantity;
import drr.regulation.common.functions.TradeForEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=UKEMIRNotionalAmountPeriodLeg1Default.class)
public abstract class UKEMIRNotionalAmountPeriodLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_ContinuousQuantitySchedule create_ContinuousQuantitySchedule;
    @Inject
    protected GetExpirationDate getExpirationDate;
    @Inject
    protected GetLeg1ResolvablePriceQuantity getLeg1ResolvablePriceQuantity;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends QuantityReportablePeriod> evaluate(TransactionReportInstruction transactionReportInstruction) {
        List emirNotionalAmountPeriods;
        List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriodsBuilder = this.doEvaluate(transactionReportInstruction);
        if (emirNotionalAmountPeriodsBuilder == null) {
            emirNotionalAmountPeriods = null;
        } else {
            emirNotionalAmountPeriods = emirNotionalAmountPeriodsBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(QuantityReportablePeriod.class, emirNotionalAmountPeriods);
        }
        return emirNotionalAmountPeriods;
    }

    protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Date> expirationDate(TransactionReportInstruction var1);

    protected abstract MapperC<? extends QuantityReportablePeriod> genericNotionalAmountSchedule(TransactionReportInstruction var1);

    public static class UKEMIRNotionalAmountPeriodLeg1Default
    extends UKEMIRNotionalAmountPeriodLeg1 {
        @Override
        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(TransactionReportInstruction transactionReportInstruction) {
            ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriods = new ArrayList<QuantityReportablePeriod.QuantityReportablePeriodBuilder>();
            return this.assignOutput(emirNotionalAmountPeriods, transactionReportInstruction);
        }

        protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> emirNotionalAmountPeriods, TransactionReportInstruction transactionReportInstruction) {
            emirNotionalAmountPeriods = this.toBuilder(this.create_ContinuousQuantitySchedule.evaluate(this.genericNotionalAmountSchedule(transactionReportInstruction).getMulti(), (Date)this.expirationDate(transactionReportInstruction).get()));
            return Optional.ofNullable(emirNotionalAmountPeriods).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<Date> expirationDate(TransactionReportInstruction transactionReportInstruction) {
            return MapperS.of((Object)this.getExpirationDate.evaluate(transactionReportInstruction));
        }

        @Override
        protected MapperC<? extends QuantityReportablePeriod> genericNotionalAmountSchedule(TransactionReportInstruction transactionReportInstruction) {
            MapperS thenArg0 = MapperS.of((Object)this.getLeg1ResolvablePriceQuantity.evaluate(this.tradeForEvent.evaluate(transactionReportInstruction))).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get());
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> item.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()));
            return thenArg2.mapItem(notionalAmountPeriod -> MapperS.of((Object)QuantityReportablePeriod.builder().setPeriodValue((BigDecimal)notionalAmountPeriod.map("getValue", datedValue -> datedValue.getValue()).get()).setPeriodEffectiveDate((Date)notionalAmountPeriod.map("getDate", datedValue -> datedValue.getDate()).get()).setPeriodEndDate(null).build()));
        }
    }
}

