/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsRegulatedMarketOrThirdCountryEquivalentMarket;
import javax.inject.Inject;

@ImplementedBy(value=IntragroupRuleDefault.class)
public abstract class IntragroupRule
implements ReportFunction<TransactionReportInstruction, Boolean> {
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsRegulatedMarketOrThirdCountryEquivalentMarket isRegulatedMarketOrThirdCountryEquivalentMarket;

    public Boolean evaluate(TransactionReportInstruction input) {
        Boolean output = this.doEvaluate(input);
        return output;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    public static class IntragroupRuleDefault
    extends IntragroupRule {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction input) {
            Boolean output = null;
            return this.assignOutput(output, input);
        }

        protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (Boolean)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isRegulatedMarketOrThirdCountryEquivalentMarket.evaluate((ReportableInformation)item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get(), RegimeNameEnum.UKEMIR)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).map("getIntragroup", reportableInformation -> reportableInformation.getIntragroup());
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

