/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.mas.rewrite.valuation.MASValuationReport;
import drr.regulation.mas.rewrite.valuation.labels.MASValuationLabelProvider;
import drr.regulation.mas.rewrite.valuation.reports.ActionTypeRule;
import drr.regulation.mas.rewrite.valuation.reports.Counterparty1Rule;
import drr.regulation.mas.rewrite.valuation.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.mas.rewrite.valuation.reports.Counterparty2Rule;
import drr.regulation.mas.rewrite.valuation.reports.DataSubmitterRule;
import drr.regulation.mas.rewrite.valuation.reports.ExecutionAgentOfCounterparty1DTCCRule;
import drr.regulation.mas.rewrite.valuation.reports.ExecutionAgentOfCounterparty2DTCCRule;
import drr.regulation.mas.rewrite.valuation.reports.ReportingSpecifiedPersonRule;
import drr.regulation.mas.rewrite.valuation.reports.ReportingTimestampRule;
import drr.regulation.mas.rewrite.valuation.reports.TechnicalRecordIdRule;
import drr.regulation.mas.rewrite.valuation.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.mas.rewrite.valuation.reports.UniqueTransactionIdentifierRule;
import drr.regulation.mas.rewrite.valuation.reports.ValuationAmountRule;
import drr.regulation.mas.rewrite.valuation.reports.ValuationCurrencyRule;
import drr.regulation.mas.rewrite.valuation.reports.ValuationMethodRule;
import drr.regulation.mas.rewrite.valuation.reports.ValuationTimestampRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.mas.rewrite.valuation", body="MAS", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=MASValuationLabelProvider.class)
@ImplementedBy(value=MASValuationReportFunctionDefault.class)
public abstract class MASValuationReportFunction
implements ReportFunction<ValuationReportInstruction, MASValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DataSubmitterRule dataSubmitterRule;
    @Inject
    protected ExecutionAgentOfCounterparty1DTCCRule executionAgentOfCounterparty1DTCCRule;
    @Inject
    protected ExecutionAgentOfCounterparty2DTCCRule executionAgentOfCounterparty2DTCCRule;
    @Inject
    protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public MASValuationReport evaluate(ValuationReportInstruction input) {
        MASValuationReport output;
        MASValuationReport.MASValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(MASValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract MASValuationReport.MASValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class MASValuationReportFunctionDefault
    extends MASValuationReportFunction {
        @Override
        protected MASValuationReport.MASValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            MASValuationReport.MASValuationReportBuilder output = MASValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected MASValuationReport.MASValuationReportBuilder assignOutput(MASValuationReport.MASValuationReportBuilder output, ValuationReportInstruction input) {
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setReportingSpecifiedPerson(this.reportingSpecifiedPersonRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierType(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setDataSubmitter(this.dataSubmitterRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setTechnicalRecordId(this.technicalRecordIdRule.evaluate(input));
            output.setExecutionAgentOfTheCounterparty1(this.executionAgentOfCounterparty1DTCCRule.evaluate(input));
            output.setExecutionAgentOfTheCounterparty2(this.executionAgentOfCounterparty2DTCCRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

