/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.functions;

import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=LookupBookingLocationDefault.class)
public abstract class LookupBookingLocation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Address evaluate(Party party) {
        Address bookingLocation;
        Address.AddressBuilder bookingLocationBuilder = this.doEvaluate(party);
        if (bookingLocationBuilder == null) {
            bookingLocation = null;
        } else {
            bookingLocation = bookingLocationBuilder.build();
            this.objectValidator.validate(Address.class, (RosettaModelObject)bookingLocation);
        }
        return bookingLocation;
    }

    protected abstract Address.AddressBuilder doEvaluate(Party var1);

    public static class LookupBookingLocationDefault
    extends LookupBookingLocation {
        @Override
        protected Address.AddressBuilder doEvaluate(Party party) {
            Address.AddressBuilder bookingLocation = Address.builder();
            return this.assignOutput(bookingLocation, party);
        }

        protected Address.AddressBuilder assignOutput(Address.AddressBuilder bookingLocation, Party party) {
            return Optional.ofNullable(bookingLocation).map(o -> o.prune()).orElse(null);
        }
    }
}

