/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.Trade;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.reports.ContractForEventRule;
import drr.regulation.techsprint.g20.mas.reports.IsFixedFloatRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FixedFloatLeg1RuleDefault.class)
public abstract class FixedFloatLeg1Rule
implements ReportFunction<TransactionReportInstruction, InterestRatePayout> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ContractForEventRule contractForEventRule;
    @Inject
    protected IsFixedFloatRule isFixedFloatRule;

    public InterestRatePayout evaluate(TransactionReportInstruction input) {
        InterestRatePayout output;
        InterestRatePayout.InterestRatePayoutBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(TransactionReportInstruction var1);

    public static class FixedFloatLeg1RuleDefault
    extends FixedFloatLeg1Rule {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(TransactionReportInstruction input) {
            InterestRatePayout.InterestRatePayoutBuilder output = InterestRatePayout.builder();
            return this.assignOutput(output, input);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.contractForEventRule.evaluate(input));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> this.isFixedFloatRule.evaluate((Trade)item.get()));
            MapperC thenArg2 = thenArg1.mapSingleToList(item -> item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()));
            MapperC thenArg3 = thenArg2.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
            output = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)thenArg3.get())).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

