/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ReportingPartyRuleDefault.class)
public abstract class ReportingPartyRule
implements ReportFunction<TransactionReportInstruction, Party> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

    public Party evaluate(TransactionReportInstruction input) {
        Party output;
        Party.PartyBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction var1);

    public static class ReportingPartyRuleDefault
    extends ReportingPartyRule {
        @Override
        protected Party.PartyBuilder doEvaluate(TransactionReportInstruction input) {
            Party.PartyBuilder output = Party.builder();
            return this.assignOutput(output, input);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder output, TransactionReportInstruction input) {
            output = (Party.PartyBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.REPORTING_PARTY))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

