/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.techsprint.g20.mas.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.techsprint.g20.mas.reports.TraderAddressForUTIRule;
import javax.inject.Inject;

@ImplementedBy(value=TraderLocationRuleDefault.class)
public abstract class TraderLocationRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected TraderAddressForUTIRule traderAddressForUTIRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class TraderLocationRuleDefault
    extends TraderLocationRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)this.traderAddressForUTIRule.evaluate(input));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg.mapSingleToItem(item -> item.map("getCurrentLocation", trader -> trader.getCurrentLocation()).map("getCountry", address -> address.getCountry())).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

