/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.standards.iosco.cde.functions.ExtractCDECallAmount;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;

@ImplementedBy(value=CDECallAmountRuleDefault.class)
public abstract class CDECallAmountRule
implements ReportFunction<Trade, BigDecimal> {
    @Inject
    protected ExtractCDECallAmount extractCDECallAmount;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;

    public BigDecimal evaluate(Trade input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(Trade var1);

    public static class CDECallAmountRuleDefault
    extends CDECallAmountRule {
        @Override
        protected BigDecimal doEvaluate(Trade input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, Trade input) {
            BigInteger bigInteger = new BigInteger("9999999999999999999999999");
            MapperS thenArg = MapperS.of((Object)this.extractCDECallAmount.evaluate(input, bigInteger == null ? null : new BigDecimal(bigInteger)));
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg.get())).get();
            return output;
        }
    }
}

